<!--start main wrapper-->
<main class="main-wrapper">
  <div class="main-content">
    <div class="row my-2">
      <div class="col-md-6">
        <h4>Users Management</h4>
      </div>
      <div class="col-md-6 text-end">
        <a href="<?php echo base_url(); ?>user/addUser" class="btn btn-primary">
          <i class="bi bi-plus-circle"></i> Add New User
        </a>
      </div>
    </div>

    <div class="row my-2">
      <div class="col-md-12">
        <form action="<?php echo base_url(); ?>user/users" method="post">
          <div class="input-group custom-search">
            <span class="input-group-text"><i class="bi bi-search"></i></span>
            <input type="text" class="form-control" name="searchText" placeholder="Search by name, email or phone..." 
                   value="<?php echo !empty($searchText) ? $searchText : ''; ?>" aria-label="Search">
            <button type="submit" class="btn btn-primary">Search</button>
            <?php if(!empty($searchText)) { ?>
            <a href="<?php echo base_url(); ?>user/users" class="btn btn-secondary">Clear</a>
            <?php } ?>
          </div>
        </form>
      </div>
    </div>

    <?php
    $success = $this->session->flashdata('success');
    $error = $this->session->flashdata('error');
    if($success) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                '.$success.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    if($error) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                '.$error.'
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
    ?>

    <div class="card">
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered align-middle">
            <thead>
              <tr>
                <th>#</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Balance</th>
                <th>Agent</th>
                <th>Created</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php
              if(!empty($users)) {
                  $count = 1;
                  foreach($users as $user) {
              ?>
              <tr>
                <td><?php echo $count++; ?></td>
                <td><?php echo htmlspecialchars($user->name); ?></td>
                <td><?php echo htmlspecialchars($user->email); ?></td>
                <td><?php echo htmlspecialchars($user->phone ?? 'N/A'); ?></td>
                <td><?php echo htmlspecialchars($user->balance ?? '0'); ?></td>
                <td><?php echo htmlspecialchars($user->parent_id ?? 'N/A'); ?></td>
                <td><?php echo isset($user->createdDtm) ? date('Y-m-d', strtotime($user->createdDtm)) : 'N/A'; ?></td>
                <td>
                  <a href="<?php echo base_url().'user/editUser/'.$user->id; ?>" class="btn btn-sm btn-warning">
                    <i class="bi bi-pencil"></i> Edit
                  </a>
                  <button class="btn btn-sm btn-danger deleteUser" data-userid="<?php echo $user->id; ?>" data-name="<?php echo htmlspecialchars($user->name); ?>">
                    <i class="bi bi-trash"></i> Delete
                  </button>
                </td>
              </tr>
              <?php
                  }
              } else {
              ?>
              <tr>
                <td colspan="8" class="text-center">No users found</td>
              </tr>
              <?php } ?>
            </tbody>
          </table>
        </div>
        
        <?php echo !empty($this->pagination->create_links()) ? $this->pagination->create_links() : ''; ?>
      </div>
    </div>
  </div>
</main>
<!--end main wrapper-->

<script type="text/javascript">
$(document).ready(function() {
    $('.deleteUser').click(function(e) {
        e.preventDefault();
        var userId = $(this).data('userid');
        var userName = $(this).data('name');
        
        if(confirm('Are you sure you want to delete user: ' + userName + '?')) {
            $.ajax({
                url: '<?php echo base_url(); ?>user/deleteUser',
                type: 'POST',
                data: { userId: userId },
                dataType: 'json',
                success: function(response) {
                    if(response.status == true) {
                        alert('User deleted successfully');
                        location.reload();
                    } else if(response.status == 'access') {
                        alert('You do not have permission to perform this action');
                    } else {
                        alert('User deletion failed');
                    }
                },
                error: function() {
                    alert('Error occurred while deleting user');
                }
            });
        }
    });
});
</script>

