<?php  
// echo "<pre>";
// print_r($amenity);
// echo "</pre>";
?>
<!--start main wrapper-->
    <main class="main-wrapper">
        <div class="main-content">
            <button class="btn guestBtn d-flex gap-2 align-items-center" id="backBtn"><img
                    src="<?php echo base_url(); ?>assets/images/arowleft.svg" alt="" width="15px"> Back</button>
            <div class="row">
                <div class="col-md-8 my-2">
                    <h3 class="fmon fw-bold"><i class="fa fa-edit"></i> Edit Amenity</h3>
                </div>
            </div>
            <div class="row my-2 justify-content-end">
                <div class="col-md-4 my-2 d-flex justify-content-end">
                    <button class="btn btn-deny" id="disable-button" data-bs-toggle="modal"
                        data-bs-target="#statusModal" onclick="disableUser()">Disable User</button>
                    <button class="btn btn-approv d-none" id="enable-button" data-bs-toggle="modal"
                        data-bs-target="#statusModal" onclick="enableUser()">Enable User</button>
                </div>
                <!-- Bootstrap Modal -->
                <div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="modalLabel">User Status</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body" id="modalBody">
                                <!-- Dynamic Content Here -->
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-body">
                <form class="row" id="reservationForm" method="post" action="<?php echo base_url(); ?>site/updateAmmenityData/<?php echo $amenity['id']; ?>">
                    <!-- Name -->
                    <div class="col-md-6 my-2">
                        <label class="form label" for="name">Name</label>
                        <input type="text" name="name" id="name" class="form-control FormInput"
                            placeholder="Amenity Name" value="<?php echo $amenity['name']; ?>" required>
                    </div>

                    <!-- Description -->
                    <div class="col-md-12 my-2">
                        <label class="form label" for="description">Description</label>
                        <textarea class="form-control FormInput" name="description" id="description"
                            placeholder="Description (Max 2000 characters)" maxlength="2000"><?php echo $amenity['description']; ?></textarea>
                        <small id="descCount" class="form-text text-muted">0/2000</small>
                    </div>

                    <!-- Image Upload & Default Selection -->
                    <div class="col-md-12 my-2">
                        <label>Current Image</label>
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <img src="<?php echo $amenity['imageUrl']; ?>" class="img-fluid" alt="Current Image">
                            </div>
                        </div>
                        <label>Upload New Image or Choose Default</label>
                        <div class="row">
                            <div class="col-md-6">
                                <input type="file" id="imageUpload" class="form-control FormInput" accept="image/*">
                            </div>
                        </div>

                        <div class="row">
                            <label>Choose an image:</label>
                            <?php 
                            $defaultImages = array();
                            for($i = 33; $i <= 56; $i++) {
                                $imgUrl = base_url()."assets/images/gallery/Image".$i.".png";
                                $defaultImages[] = $imgUrl;
                            }
                            foreach($defaultImages as $img): 
                            ?>
                            <div class="col-md-2 my-2">
                                <input type="radio" name="defaultImage" class="default-image form-check-input"
                                    value="<?php echo $img; ?>" <?php echo ($amenity['imageUrl'] == $img) ? 'checked' : ''; ?>>
                                <img class="img-select" src="<?php echo $img; ?>">
                            </div>
                            <?php endforeach; ?>
                            <input type="hidden" id="selectedImage" name="selectedImage" value="<?php echo $amenity['imageUrl']; ?>">
                        </div>
                    </div>

                    <!-- Start Date -->
                    <div class="col-md-6 my-2">
                        <label class="form-label" for="startDate">Start Date</label>
                        <input type="date" name="startDate" id="startDate" class="form-control FormInput" 
                            value="<?php echo date('Y-m-d', $amenity['startDateMs']/1000); ?>" required>
                    </div>

                    <!-- End Date -->
                    <div class="col-md-6 my-2">
                        <label class="form-label" for="endDate">End Date</label>
                        <input type="date" name="endDate" id="endDate" class="form-control FormInput" 
                            value="<?php echo date('Y-m-d', $amenity['endDateMs']/1000); ?>" required>
                    </div>

                    <!-- Calendar Type -->
                    <div class="col-md-6 my-2">
                        <label class="form label" for="calendarType">Type of calendar <?php echo ($amenity['calendarType'] == 'custom_slots') ? 'selected' : ''; ?></label>
                        <select name="calendarType" id="calendarType" class="form-select Formselet">
                            <option value="">Select Type <?php echo $amenity['calendarType']; ?></option>
                            <option value="hourly" <?php echo ($amenity['calendarType'] == 'hourly') ? 'selected' : ''; ?>>Hourly</option>
                            <option value="day_night" <?php echo ($amenity['calendarType'] == 'day_night') ? 'selected' : ''; ?>>Day & Night</option>
                            <option value="once_day" <?php echo ($amenity['calendarType'] == 'once_day') ? 'selected' : ''; ?>>Once a Day</option>
                            <option value="custom_slots" <?php echo ($amenity['calendarType'] == 'custom_slots') ? 'selected' : ''; ?>>Custom Slots</option>
                        </select>
                    </div>

                    <!-- Time Fields (Dynamic) -->
                    <div class="col-md-6 my-2" id="timeFields">
                        <?php if(isset($amenity['timeforapp'])): ?>
                            <!-- Time fields will be populated by JavaScript -->
                        <?php endif; ?>
                    </div>

                    <!-- Advance Booking Time -->
                    <div class="col-md-6 my-2">
                        <label class="form label" for="advanceBooking">Advance Booking time </label>
                        <select name="advanceBooking" id="advanceBooking" class="form-select Formselet">
                            <option value="any" <?php echo ($amenity['advanceBooking'] == 'any') ? 'selected' : ''; ?>>Any Time</option>
                            <option value="24" <?php echo ($amenity['advanceBooking'] == '24') ? 'selected' : ''; ?>>24 Hours</option>
                            <option value="week" <?php echo ($amenity['advanceBooking'] == 'week') ? 'selected' : ''; ?>>1 Week</option>
                            <option value="month" <?php echo ($amenity['advanceBooking'] == 'month') ? 'selected' : ''; ?>>1 Month</option>
                        </select>
                    </div>

                    <!-- Payment Required -->
                    <div class="col-md-6 my-2 align-self-center">
                        <div>
                            <label><input type="checkbox" class="form-check-input" name="paymentRequired" id="paymentRequired" 
                                <?php echo ($amenity['paymentRequired']) ? 'checked' : ''; ?>> Payment Required?</label>
                            <label><input type="checkbox" class="form-check-input" name="capacityLimit" id="capacityLimit"
                                <?php echo ($amenity['capacityLimit']) ? 'checked' : ''; ?>> Enable Capacity Limit?</label>
                            <label><input type="checkbox" class="form-check-input" name="approvalRequired" id="approvalRequired"
                                <?php echo ($amenity['approvalRequired']) ? 'checked' : ''; ?>> Approval Required?</label>
                        </div>
                    </div>

                    <div class="col-md-6 my-2" id="paymentFields" style="display: <?php echo ($amenity['paymentRequired']) ? 'block' : 'none'; ?>;">
                        <input type="text" name="price" id="price" class="form-control FormInput" placeholder="Price" 
                            value="<?php echo $amenity['price']; ?>">
                        <select name="currency" id="currency" class="form-select Formselet mt-2">
                            <option value="usd" <?php echo ($amenity['currency'] == 'usd') ? 'selected' : ''; ?>>USD</option>
                            <option value="eur" <?php echo ($amenity['currency'] == 'eur') ? 'selected' : ''; ?>>EUR</option>
                        </select>
                    </div>

                    <div class="col-md-6 my-2" id="capacityField" style="display: <?php echo ($amenity['capacityLimit']) ? 'block' : 'none'; ?>;">
                        <input type="number" name="maxPeople" id="maxPeople" class="form-control FormInput"
                            placeholder="Max People" value="<?php echo $amenity['maxPeople']; ?>">
                    </div>

                    <!-- Reservation Limits -->
                    <div class="col-md-6 my-2">
                        <label class="form label" for="limitPerDay">Limit of reservations per day</label>
                        <select name="limitPerDay" id="limitPerDay" class="form-select Formselet">
                            <option value="no_limit" <?php echo ($amenity['limitPerDay'] == 'no_limit') ? 'selected' : ''; ?>>No Limit</option>
                            <option value="1" <?php echo ($amenity['limitPerDay'] == '1') ? 'selected' : ''; ?>>1</option>
                            <option value="2" <?php echo ($amenity['limitPerDay'] == '2') ? 'selected' : ''; ?>>2</option>
                        </select>
                    </div>

                    <div class="col-md-6 my-2">
                        <label class="form label" for="limitPerWeek">Limit of reservations per week</label>
                        <select name="limitPerWeek" id="limitPerWeek" class="form-select Formselet">
                            <option value="no_limit" <?php echo ($amenity['limitPerWeek'] == 'no_limit') ? 'selected' : ''; ?>>No Limit</option>
                            <option value="1" <?php echo ($amenity['limitPerWeek'] == '1') ? 'selected' : ''; ?>>1</option>
                            <option value="2" <?php echo ($amenity['limitPerWeek'] == '2') ? 'selected' : ''; ?>>2</option>
                        </select>
                    </div>

                    <div class="col-md-6 my-2">
                        <input type="text" name="display_orders" id="display_orders" class="form-control FormInput"
                            placeholder="Display Orders" value="<?php echo $amenity['display_orders']; ?>">
                    </div>

                    <!-- Terms & Conditions -->
                    <div class="col-md-12 my-2">
                        <label>Current Terms & Conditions PDF</label>
                        <?php if(!empty($amenity['termsFile'])): ?>
                            <div class="mb-2">
                                <a href="<?php echo $amenity['termsFile']; ?>" target="_blank" class="btn btn-sm btn-info">View Current PDF</a>
                            </div>
                        <?php endif; ?>
                        <label>Upload New Terms & Conditions (PDF)</label>
                        <input type="file" id="termsFile" class="form-control FormInput" name="termsFile" accept="application/pdf">
                    </div>

                    <!-- Submit Button -->
                    <div class="col-md-12 my-2 text-center">
                        <button type="submit" class="btn autBtn py-2">Update Amenity</button>
                    </div>
                </form>

              
            </div>
        </div>
    </main>
    <!--end main wrapper-->
