
    <!--start main wrapper-->
    <main class="main-wrapper">
        <div class="main-content">


            <div class="row">
                <div class="col-md-6 my-2">
                    <div class="d-flex align-items-center gap-2 mb-2">
                        <img src="<?php echo base_url(); ?>assets/images/issued.svg" alt="" height="30px">
                        <h3 class="fmon fw-bolder m-0">Issues</h3>
                    </div>
                </div>
                <div class="col-md-6 d-flex gap-2 justify-content-end align-items-center">
                    <a href="<?php echo base_url().'site/addcase'; ?>" class="btn addBtn d-flex gap-2 align-items-center"><img
                            src="<?php echo base_url(); ?>assets/images/megaIcons/aplu.png" alt="">Case
                    </a>
                    <div class="btn bg-white d-flex gap-5 align-items-center px-3 border-15" data-bs-toggle="offcanvas"
                        data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
                        Filter <img src="<?php echo base_url(); ?>assets/images/e.png " alt="" width="20px">
                    </div>
                    <!-- filter -->
                    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight"
                        aria-labelledby="offcanvasRightLabel">
                        <div class="offcanvas-header">
                            <h5 class="offcanvas-title" id="offcanvasRightLabel">Filters</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="offcanvas"
                                aria-label="Close"></button>
                        </div>
                        <div class="offcanvas-body">
                            <!-- Unread Messages Filter -->
                            <div class="mb-3">
                                <label for="unreadMessages" class="form-label filter-label">Unread Messages</label>
                                <select id="unreadMessages" class="form-select">
                                    <option value="">Select Status</option>
                                    <option value="true">True</option>
                                    <option value="false">False</option>
                                </select>
                            </div>

                            <!-- Status Filter -->
                            <div class="mb-3">
                                <label for="status" class="form-label filter-label">Status</label>
                                <select id="status" class="form-select">
                                    <option value="">Select Status</option>
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                    <option value="pending">Pending</option>
                                </select>
                            </div>

                            <!-- Category Filter -->
                            <div class="mb-3">
                                <label for="category" class="form-label filter-label">Category</label>
                                <select id="category" class="form-select">
                                    <option value="">Select Category</option>
                                    <option value="electronics">Electronics</option>
                                    <option value="furniture">Furniture</option>
                                    <option value="clothing">Clothing</option>
                                    <option value="books">Books</option>
                                </select>
                            </div>

                            <!-- House Number Filter with Search -->
                            <div class="mb-3">
                                <label for="houseNumber" class="form-label filter-label">House Number</label>
                                <input type="text" class="form-control" id="houseNumber"
                                    placeholder="Search House Number" oninput="filterHouseNumbers()">
                                <ul id="houseNumberList" class="list-group mt-2"></ul>
                            </div>

                            <!-- Created Date Filter -->
                            <div class="mb-3">
                                <label for="createdDate" class="form-label filter-label">Created Date</label>
                                <input type="date" id="createdDate" class="form-control">
                            </div>

                            <button class="btn addBtn w-100" onclick="applyFilters()">Apply Filters</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row my-2">
                <div class="col-md-3 my-2 ">
                    <div class="card border-15 issueCard">
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col-md-8">
                                    <div class="chart" id="chartd"></div>
                                </div>
                            </div>
                            <p class="ft8 text-center mb-0 fw-bold">45%</p>
                            <p class="ft9 text-center mb-0">Reolved</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 my-2 ">
                    <div class="card border-15 issueCard">
                        <div class="card-body">
                            <p class="ft8  fw-bold">Total : 512</p>
                            <div class="d-flex gap-2 align-items-center my-2">
                                <img src="<?php echo base_url(); ?>assets/images/actissue.png" alt="">
                                <p class="ft8 text-center mb-0 fw-bold">160</p>
                                <p class="ft9 text-center mb-0 ">Active</p>
                            </div>
                            <div class="d-flex gap-2 align-items-center my-3">
                                <img src="<?php echo base_url(); ?>assets/images/closissue.png" alt="">
                                <p class="ft8 text-center mb-0 fw-bold">214</p>
                                <p class="ft9 text-center mb-0">Closed</p>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-md-3 my-2 ">
                    <div class="card border-15 issueCard">
                        <div class="card-body">
                            <div id="chartbar"></div>

                        </div>
                    </div>
                </div>
                <div class="col-md-3 my-2 ">
                    <div class="card border-15 issueCard h-100 ">
                        <div class="card-body d-flex  align-items-center">
                            <div>
                                <div class="d-flex gap-3 align-items-center">
                                    <img src="./assets//images/newp.png" alt="" width="80px" height="80px">
                                    <div>
                                        <p class="ft9 mb-0">new</p>
                                        <p class="ft8  mb-0 fw-bold">45%</p>
                                        <p class="ft9 mb-0">+19 from yesterday</p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">

                    <div class="input-group border-15">
                        <span class="input-group-text  border-15"><img src="<?php echo base_url(); ?>assets/images/serIcon.png" alt=""
                                width="20px"></span>
                        <input type="text" name="" id="" class="form-control form-Search  border-15  py-2"
                            placeholder="search">
                    </div>

                </div>

                <div>
                    <div class="table-responsive mt-3 ">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th scope="col">Case No.</th>
                                    <th scope="col">House/Security</th>

                                    <th scope="col">Tittle</th>
                                    <th scope="col">Category</th>

                                    <th scope="col">Created by</th>
                                    <th scope="col">User Type</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Created at</th>
                                </tr>
                            </thead>
                            <div class="">
                                <tbody class="">
                             <?php foreach($issues as $key=> $issue){ 
                              
                                $unitinfo=$this->common->readdatadocument('units',$issue['unitId']);
                                $userinfo=$this->common->readdatadocument('Users',$issue['userId']);
                                // echo "<pre>";
                                // print_r($userinfo);
                                // echo "</pre>";

                                ?>
                                <tr>
                                        <td>
                                            <div class="h40">
                                                <div class="h40 d-flex align-items-center gap-2">
                                                    <i class="fas fa-envelope closeenv" id="toggleIcon"></i>
                                                    <a href="<?php echo base_url().'site/case/'.$key; ?>" class="hNum m-0"><?php echo $key;; ?></a>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex gap-2 align-items-center">
                                                <div class="numBox">
                                                    <?php echo $unitinfo['unit']; ?>
                                                </div>
                                                <?php echo $unitinfo['zone']; ?>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center h-100">
                                                <p class="ft7 fmon m-0"><?php echo $issue['subject']; ?></p>
                                            </div>

                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center h-100">
                                                <p class="ft7 fmon m-0"><?php echo $issue['category']; ?></p>
                                            </div>

                                        </td>
                                        <td>
                                            <p class="ft7 fmon m-0"><?php echo $userinfo['fullName']; ?></p>
                                        </td>

                                        <td>
                                            <div class="d-flex align-items-center h-100">
                                                <p class="ft7 fmon m-0"><?php echo $userinfo['userType']; ?></p>
                                            </div>

                                        </td>


                                        <td>

                                            <div class="h40">
                                                <p class="hNum">
                                                <?php if($issue['isOpen']==true){ ?>
                                                <span class="badge bg-success">Active</span>
                                                <?php }else{ ?>
                                                <span class="badge bg-danger">Closed</span>
                                                <?php } ?>
                                                </p>
                                            </div>

                                        </td>
                                        <td>
                                            <p class="ft7 fmon m-0">
                                                <?php echo date('d/m/Y H:i',$issue['createdAt']/1000); ?>
                                               
                                            </p>
                                        </td>
                                    </tr>
                             <?php } ?>




                                    <!-- Add more rows as needed -->
                                </tbody>
                            </div>
                        </table>
                    </div>
                </div>
            </div>
        </div>



    </main>
    <!--end main wrapper-->