<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Domun</title>
    <!-- bootstrap cdn -->
    <link
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css"
      rel="stylesheet"
    />
    <!-- custom css -->
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>" />

    <!-- fontawesone link -->
    <link
      rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
    />
    <!--favicon-->
    <link rel="icon" href="<?= base_url('assets/images/favicon-32x32.png') ?>" type="image/png" />
  </head> 
  <body class="bg-main pt-5 pb-5">
    <div class="container-flid mt-5 pt-5 mb-5 pb-5">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-md-8 my-2">
            <div class="d-flex justify-content-center">
              <img class="w-50" src="<?= base_url('assets/images/logo.png') ?>" alt="" />
            </div>
            <p class="mt-5 mb-0 text-center fs2">Login</p>
            <p class="fs3 text-center">
              Enter your Login details to Access Your Account
            </p>

            <div class="row mb-2 justify-content-center">
              <div class="col-md-6 justify-content-center">
  <?php
    $successMessage = $this->session->flashdata('successmessage');
    $warningmessage = $this->session->flashdata('warningmessage');

    if (isset($successMessage)) {
      echo '<div id="alertmessage" class="col-md-12">
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          ' . output($successMessage) . '
          <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
      </div>';
    }

    if (isset($warningmessage)) {
      echo '<div id="alertmessage" class="col-md-12">
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
          ' . output($warningmessage) . '
          <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
      </div>';
    }
  ?>
</div>

                               <div class="col-md-12 my-2">
                <form action="<?= base_url('login/login_action') ?>" method="post">
                  <div class="my-2 row justify-content-center">
                    <div class="col-md-6 my-2">
                      <input
                        class="form-control formInp py-2"
                        type="text"
                        required
                        placeholder="Email Address"
                        name="email"
                      />
                    </div>
                  </div>
                  <div class="my-2 row justify-content-center">
                    <div class="col-md-6 my-2 position-relative">
                      <input
                        class="form-control formInp2 py-2"
                        type="password"
                        placeholder="Password"
                        name="password"
                        required
                      />

                      <a href="#" class="mb-0 mt-2 d-none"
                        ><p class="text-center mt-2 fs5 text-white">
                          Forgot Password?
                        </p></a
                      >
                    </div>
                  </div>

                  <div class="row my-2 justify-content-center">
                    <div class="col-md-4">
                      <div class="row justify-content-center">
                        <div class="col-md-12">
                          <div
                            class="d-flex flex-column justify-content-center align-items-center"
                          >
                          <input type="submit" value="Login" class="btn my-2 signB py-2" />
                           
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
              
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <script
      src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"
      integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL"
      crossorigin="anonymous"
    ></script>

    <script>
      document.addEventListener("DOMContentLoaded", function () {
        const eyeIcons = document.querySelectorAll(".eye");

        eyeIcons.forEach(function (icon) {
          icon.addEventListener("click", function () {
            const passwordField = document.querySelector(".formInp2");
            if (passwordField.type === "password") {
              passwordField.type = "text";
              this.classList.remove("fa-eye");
              this.classList.add("fa-eye-slash");
            } else {
              passwordField.type = "password";
              this.classList.remove("fa-eye-slash");
              this.classList.add("fa-eye");
            }
          });
        });
      });
    </script>
  </body>
</html>
