 <!--start main wrapper-->
    <main class="main-wrapper">
        <div class="main-content">
            <h3 class=" fmon fw-bolder ">Reservations</h3>

            <ul class="  row ps-2" id="myTab" role="tablist">
                <li class="nav-item nav-link col-md-3" role="presentation">
                    <a href="<?php echo base_url().'site/reservations' ?>" class="card un-card <?php if($type =="pending"){
                        echo "active";
                    } ?> w-100 " id="pending-tab" aria-controls="pending" aria-selected="true">
                        <div class="card-body w-100">
                            <div class="d-flex justify-content-between">
                                <p class="ft4 fmon">Pending</p>
                                <img src="<?php echo base_url(); ?>assets/images/pend.png" alt="" width="50px">
                            </div>
                        </div>
                    </a>
                </li>
                <li class="nav-item col-md-3" role="presentation">
                <a href="<?php echo base_url().'site/approvedreservations' ?>"
                 class="card un-card <?php if($type =="approved"){
                        echo "active";
                    } ?> w-100 " id="pending-tab" aria-controls="pending" aria-selected="true">
                        <div class="card-body w-100">
                            <div class="d-flex justify-content-between">
                                <p class="ft4 fmon">Approved</p>
                                <img src="<?php echo base_url(); ?>assets/images/approv.png" alt="" width="50px">
                            </div>
                        </div>
                    </a>
                </li>
                <li class="nav-item  col-md-3" role="presentation">
                <a href="<?php echo base_url().'site/allreservations' ?>"
                 class="card un-card <?php if($type =="history"){
                        echo "active";
                    } ?> w-100 " id="pending-tab" aria-controls="pending" aria-selected="true">
                        <div class="card-body w-100">
                            <div class="d-flex justify-content-between">
                                <p class="ft4 fmon">History</p>
                                <img src="<?php echo base_url(); ?>assets/images/hist.png" alt="" width="50px">
                            </div>
                        </div>
                    </a>
                </li>
            </ul>




            <!-- Tab Content -->
            <div class="tab-content my-4" id="myTabContent">

                <!-- Pending Tab -->

                <div class="row">
                    <div class="col-md-7">

                        <div class="input-group border-15">
                            <span class="input-group-text  border-15"><img src="<?php echo base_url(); ?>assets/images/serIcon.png" alt=""
                                    width="25px"></span>
                            <input type="text" name="" id="" class="form-control form-Search  border-15  py-2"
                                placeholder="search">
                        </div>

                    </div>
                    <div class="col-md-5 d-flex justify-content-end gap-2">

                        <a href="<?php echo base_url().'site/addreservations'; ?>" class="btn addBtn d-flex gap-2 align-items-center"><img
                                src="<?php echo base_url(); ?>assets/images/megaIcons/aplu.png" alt="">Add Reservations</a>
                        <div class="btn bg-white d-flex gap-5 align-items-center px-3 border-15"
                            data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
                            Filter <img src="<?php echo base_url(); ?>assets/images/e.png " alt="" width="20px">

                        </div>
                        <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight"
                            aria-labelledby="offcanvasRightLabel">
                            <div class="offcanvas-header">
                                <h5 class="offcanvas-title" id="offcanvasRightLabel">Filters</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="offcanvas"
                                    aria-label="Close"></button>
                            </div>
                            <div class="offcanvas-body">
                                <!-- Amenity Filter (Searchable) -->
                                <!-- <div class="mb-3">
                                    <label for="amenity" class="form-label">Amenity</label>
                                    <input type="text" class="form-control" id="amenity" placeholder="Search Amenity"
                                        oninput="filterAmenities()">
                                    <ul id="amenityList" class="list-group mt-2"></ul>
                                </div> -->

                                <!-- Unit Filter -->
                                <!-- <div class="mb-3">
                                    <label for="unit" class="form-label">Unit</label>
                                    <select class="form-select" id="unit">
                                        <option value="">Select Unit</option>
                                        <option value="unit1">Unit 1</option>
                                        <option value="unit2">Unit 2</option>
                                        <option value="unit3">Unit 3</option>
                                    </select>
                                </div> -->

                                <!-- Date Filter -->
                                <div class="mb-3">
                                    <label for="date" class="form-label">Date</label>
                                    <input type="date" class="form-control" id="date">
                                </div>

                                <!-- Slot Filter -->
                                <!-- <div class="mb-3">
                                    <label for="slot" class="form-label">Slot</label>
                                    <select class="form-select" id="slot">
                                        <option value="">Select Slot</option>
                                        <option value="morning">Morning</option>
                                        <option value="afternoon">Afternoon</option>
                                        <option value="evening">Evening</option>
                                    </select>
                                </div> -->

                                <!-- Price Filter -->
                                <!-- <div class="mb-3">
                                    <label for="price" class="form-label">Price</label>
                                    <input type="number" class="form-control" id="price" placeholder="Enter Price">
                                </div> -->

                                <!-- Is Paid Filter -->
                                <!-- <div class="mb-3">
                                    <label for="isPaid" class="form-label">Is Paid</label>
                                    <select class="form-select" id="isPaid">
                                        <option value="">Select</option>
                                        <option value="yes">Yes</option>
                                        <option value="no">No</option>
                                    </select>
                                </div> -->

                                <button class="btn addBtn w-100" onclick="applyFilters()">Apply Filters</button>
                            </div>

                        </div>

                    </div>
                </div>
                <div class="tab-pane fade show active" id="pending" role="tabpanel" aria-labelledby="pending-tab">


                    <div>
                        <div class="table-responsive mt-3 ">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th scope="col">Amenity</th>
                                        <th scope="col">Unit</th>

                                        <th scope="col">Date</th>
                                        <th scope="col">Slot</th>

                                        <th scope="col">Price</th>
                                        <th scope="col">Is Paid?</th>
                                        <th scope="col">Actions</th>

                                    </tr>
                                </thead>
                                <div class="">
                                    <tbody class="">
                                        <?php foreach ($reservations as $key => $reservation) { 
                              
                                            ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex gap-2 align-items-center">
                                                    <img class="usrImage3" src="<?php echo $reservation['eventImageUrl']; ?>" alt="">
                                                    <p class="ft7 fmon m-0"><?php echo $reservation['eventName']; ?></p>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center h-100">
                                                    <p class="ft7 fmon m-0"><?php echo getUnitName($reservation['unitId']); ?></p>
                                                </div>

                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center h-100">
                                                    <p class="ft7 fmon m-0"><?php echo date('d M Y', strtotime($reservation['eventDate'])); ?></p>
                                                </div>

                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center h-100">
                                                    <p class="ft7 fmon m-0"><?php echo $reservation['reservedSlot']; ?></p>
                                                </div>

                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center h-100">
                                                    <p class="ft7 fmon m-0">$<?php echo $reservation['numberOfPersons']; ?></p>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="d-flex align-items-center h40 ">
                                                    <div class="b-border-success  px-3 br-7">
                                                        <span class="ft-7 b-text-success m-0">paid</span>
                                                    </div>
                                                </div>

                                            </td>


                                            <td>
                                                <div class="d-flex gap-2 align-items-center h40">
                                                    <a href="<?php echo base_url().'site/viewreservation/'.$key; ?>" class="">
                                                        <img src="<?php echo base_url(); ?>assets/images/eyer.svg" alt="">
                                                    </a>
                                                    <?php if($reservation['isApproved']=="pending"){ ?>
                                                    <a href="#" data-bs-toggle="modal" data-bs-target="#denyModal">
                                                        <img src="<?php echo base_url(); ?>assets/images/delr.svg" alt="">
                                                    </a>
                                                      <!-- Modal for Deny Reason -->
                                    <div class="modal fade" id="denyModal" tabindex="-1"
                                        aria-labelledby="denyModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="denyModalLabel">Deny Reason</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form action="<?php echo base_url().'site/submitDenyReason'; ?>" method="post">
                                                <div class="modal-body">
                                                    <input type="hidden" name="reservationId" id="reservationId" value="<?php echo $key; ?>">
                                                    <input class="form-control my-2" type="text" name="deny_title"
                                                        id="deny_title" placeholder="Title">
                                                    <textarea class="form-control" id="denyReason" name="denyReason"
                                                        rows="4" placeholder="Enter the reason for denial"></textarea>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Cancel</button>
                                                    <button type="button" class="btn btn-danger"
                                                        onclick="submitDenyReason()">Submit</button>
                                                </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                                    <?php } ?>
                                                </div>
                                            </td>

                                        </tr>
                                        <?php } ?>




                                        <!-- Add more rows as needed -->
                                    </tbody>
                                  

                                </div>
                            </table>
                           
                        </div>
                    </div>
                </div>
         
                
            </div>

        </div>
        </div>
        </div>
        </div>

    </main>
    <!--end main wrapper-->
