<?php
defined('BASEPATH') or exit('No direct script access allowed');
use Kreait\Firebase\Exception\FirebaseException;
//use Throwable;

class Login extends CI_Controller
{





	//To load initial libraries, functions
	function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('directory');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->load->model('common');
		$this->load->library('session');
				$this->load->model('customer_model');
	}
	
		public function deleteUser(){

          $id = $this->input->post("userId");




		$response = $this->customer_model->delete_customer($id);
		if (!$response) {
				$data['success']=0;
				$data['msg']="Something Error Occured";
				echo json_encode($data);
				exit;
		}
		$response = $this->common->deletedatamodel("Users", $id);
		$x=$this->common->readdatafromcollectionbetween2where("Posts","userId","=",$id);
		foreach ($x as $key => $value) {
		  //echo $key."<br>";
		  $this->common->deletedatamodel("Posts", $key);
	  }

	
		$data['success']=1;
				$data['msg']="User has been deleted";
				echo json_encode($data);
				exit;

		}


	public function index()
	{
		
		if (!empty($this->session->userdata('session_data'))) {
			$url = base_url('dashboard');
			header("location: $url");
		} else {
			$this->load->view('login');
		}
	}

	public function login_action()
	{

		$email = $this->input->post("email");
		$password = $this->input->post("password");

		$firebase = $this->firebase->init();

		$auth = $firebase->createAuth();
/*
		if($email=="admin@gmail.com" && $password=="1234"){
			$session_data = array(
				'userId' => 1,
				'name' => "SuperAdmin",
				'email' => "superadmin",
				'adminId' => 1,
				'firebaseToken' => "xyz"
			);
			$this->session->set_userdata('session_data', $session_data);

			redirect(base_url('Site'));
		}else{
			$this->session->set_flashdata('warningmessage', 'Invalid email and/or password !');
			redirect(base_url('login'));
		}
exit;
*/


		try{
			$signInResult = $auth->signInWithEmailAndPassword($email, $password);
		}catch (FirebaseException $e) {
			$this->session->set_flashdata('warningmessage', 'Invalid email and/or password !');
			redirect(base_url('login'));
		}
		

		$my = $signInResult->data();
     $admin=$this->common->readdatadocument("Admins",$my['localId']);

	
		if (empty($my["idToken"]) && empty($admin)) {
			$this->session->set_flashdata('warningmessage', 'Invalid email and/or password !');
			redirect(base_url('login'));
		}



		if (!empty($my["idToken"]) && !empty($admin)) {

			$session_data = array(
				'userId' => $my["localId"],
				'name' => $admin["name"],
				'email' => $admin["email"],
				'role' => $admin["role"],
				'adminId' => $adminId,
				'firebaseToken' => $my["idToken"]
			);
			$this->session->set_userdata('session_data', $session_data);

			redirect(base_url('site'));
		} else {
			$this->session->set_flashdata('warningmessage', 'Invalid email and/or password !');
			redirect(base_url('login'));
		}
	}

	//To logout session from browser
	public function logout()
	{
		// Removing session data
		$sess_array = array('userId' => '');
		$this->session->unset_userdata('session_data', $sess_array);
		$this->session->sess_destroy();
		$this->session->set_flashdata('successmessage', 'Successfully Logged out !');
		redirect(base_url('login'));
	}
}