<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

	 function __construct()
     {
          parent::__construct();
          $this->load->database();
          $this->load->helper('url');
          $this->load->library('session');
          $this->load->model('dashboard_model');
          $this->load->model('common');
     }

	public function index()
	{
          $data["users"] = $this->common->readnumberofdocumentsincollectionbetween("Users", 'userRole', '=', 'user');
          $this->template->template_render('dashboard',$data);
	}
	

	public function events()
	{
          $data["events"] = $this->dashboard_model->get_events();
          $this->template->template_render('events',$data);
	}

	public function specialities()
	{
          $data["specialities"] = $this->dashboard_model->get_specialities();
          $this->template->template_render('specialities',$data);
	}
	
  public function addevent()
	{
		$this->template->template_render('event_add');
	}

	public function addspeciality()
	{
		$this->template->template_render('specialities_add');
	}

  public function insertevent()
	{
		$data = $this->input->post();

		$response = $this->dashboard_model->add_event($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'New event added successfully');
			redirect(base_url().'dashboard/events');
		} else {
			$errormsg = 'Error! Event not added, please check event data.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'dashboard/addevent');
		}
	}

	public function insertspeciality()
	{
		$data = $this->input->post();

		$response = $this->dashboard_model->add_speciality($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'New speciality added successfully');
			redirect(base_url().'dashboard/specialities');
		} else {
			$errormsg = 'Error! Speciality not added, please check data.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'dashboard/specialities');
		}
	}

  public function updateevent()
	{
		$data = $this->input->post();

		$firebase = $this->firebase->init();
        $storage = $firebase->createStorage();
        $defaultBucket = $storage->getBucket();

        $data = $this->input->post();


        if ($_FILES['image']['tmp_name'] != '') {
            $fileName = "Events/events" . rand() . time() . $_FILES['image']['name'];
            $uploadedFile = $defaultBucket->upload(
              file_get_contents($_FILES['image']['tmp_name']),
              [
                'name' => $fileName,
				'predefinedAcl' => 'publicRead'
              ]
            );
            $data['image'] = 'https://firebasestorage.googleapis.com/v0/b/tattoo-f01b9.appspot.com/o/'.$fileName.'?alt=media';
          }
        $data['date'] = strtotime($data['date']);

		$response = $this->common->updatedatamodel("Events", $data["id"], $data);
    
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Event updated added successfully');
			redirect(base_url().'dashboard/events');
		} else {
			$errormsg = 'Error! Event not updated, please check event data.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'dashboard/addevent'.$data['id']);
		}
	}

	public function updatespeciality()
	{
		$data = $this->input->post();
		

		$response = $this->common->updatedatamodel("Specialities", $data["id"], $data);
    
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Speciality updated successfully');
			redirect(base_url().'dashboard/specialities');
		} else {
			$errormsg = 'Error! Speciality not updated, please check data.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'dashboard/addspeciality'.$data['id']);
		}
	}

  public function editevent()
	{
		$eid = $this->uri->segment(3);
		$data['event'] = $this->common->readdatadocument("Events",$eid);
		$data['event']['id'] = $eid;
		$this->template->template_render('event_add', $data);
	}

	public function editspeciality()
	{
		$id = $this->uri->segment(3);
		$data['speciality'] = $this->common->readdatadocument("Specialities",$id);
		$data['speciality']['id'] = $id;
		$this->template->template_render('specialities_add', $data);
	}

	public function deleteevent($eid){
		$response = $this->common->deletedatamodel("Events",$eid);

		if ($response) {
			$this->session->set_flashdata('successmessage', 'Event deleted successfully');
			redirect(base_url().'dashboard/events');
		} else {
			$errormsg = 'Error! Event cannot be deleted.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'dashboard/events');
		}
	}

	public function deletespeciality($id){
		$response = $this->common->deletedatamodel("Specialities",$id);

		if ($response) {
			$this->session->set_flashdata('successmessage', 'Speciality deleted successfully');
			redirect(base_url().'dashboard/specialities');
		} else {
			$errormsg = 'Error! Speciality cannot be deleted.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'dashboard/specialities');
		}
	}
     
}