<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
  }
  
  public function settings()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");
    
    
    $this->template->template_render('settings', $data);
  }

  

  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Settings has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }



  public function index()
  {
    $data['freelancers'] = $this->common->readnumberofdocumentsincollectionbetween('Users', 'userRole', '=', 'freelance');
 //   $data['users'] = $this->common->readnumberofdocumentsincollectionbetween('Users', 'userRole', '=', 'user');
    $data['totalUsers'] = $this->common->readnumberofdocumentsincollection('Users');
    $data['categories'] = $this->common->readnumberofdocumentsincollection('Groups');
    $data['Feedback'] = $this->common->readnumberofdocumentsincollection('Feedback');
    $users = $this->common->readdatafromcollectionwhereclause("Users",'userRole', '!=', 'admin');
    $data['users']=count($users);
      foreach ($users as $key => $user) {
        $timestamps[$key]    = $user['createdTime'];
    }
    array_multisort($timestamps, SORT_ASC, $users);
    $labels = array();

    $labels[0] = date('F', strtotime(date('F')." - 3 months"));
    for($i =1; $i<=5; $i++) {
      $timestamp = strtotime($labels[$i-1].' + 1 month');
      $labels[$i] = date('F', $timestamp);
    }
    $labelStr = '';
    foreach($labels as $label) {
      $labelStr .= '"'.$label.'", ';
    }
    
    $data['labelStr'] = $labelStr;
    $dataStr = '';
    for($i =0; $i<count($labels); $i++) {
      $num = 0;
      foreach($timestamps as $timestamp) {
        if($labels[$i] == date('F', $timestamp/1000)) {
          $num += 1;
        }
      }
      $dataStr .= $num.',';
    }
    $data['dataStr'] = $dataStr;

   
    $this->template->template_render('dashboard', $data);
  }

  public function categories()
	{

		$data['categories'] = $this->common->readdatafromcollectionwhereclause('Groups');
		$this->template->template_render('categories', $data);
	}
//

public function subscription()
	{

		$data['categories'] = $this->common->readdatafromcollectionwhereclause('Subscriptions');
		$this->template->template_render('subscription', $data);
	}

  public function orders()
	{

		$data['rides'] = $this->common->readdatafromcollectionwhereclause('Services');
		$this->template->template_render('income', $data);
	}

  public function subcategories()
	{
    $jana=array();
   
		$data['categories'] = $this->common->readdatafromcollectionwhereclause('Feedback');
		$this->template->template_render('subcategories', $data);
	}

  public function addcategory()
	{

		$this->template->template_render('addcategory');
	}

  public function addsubcategory()
	{
    $data['catelist'] = $this->common->readdatafromcollectionwhereclause('Category');
		$this->template->template_render('addsubcategory',$data);
	}
//insertsubcategory
public function updatesubcategory()
	{
    $data = $this->input->post();
		$response = $this->common->updatedatamodel('SubCategory', $data['id'], $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'SubCategory updated successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/subcategories'));
	}

public function insertsubcategory()
	{
		$firebase = $this->firebase->init();
        $storage = $firebase->createStorage();
        $defaultBucket = $storage->getBucket();	
	    	$data = $this->input->post();
   
   
    $response = $this->common->addnewdatamodel('SubCategory', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'SubCategory added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/subcategories'));		
	}

  //addsubcategory
  public function insertcategory()
	{
		$firebase = $this->firebase->init();
        $storage = $firebase->createStorage();
        $defaultBucket = $storage->getBucket();	
		$data = $this->input->post();
   
    if ($_FILES['image']['tmp_name'] != '') {
      $fileName = "events" . rand() . time() . $_FILES['image']['name'];
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['image']['tmp_name']),
        [
          'name' => $fileName,
  'predefinedAcl' => 'publicRead'
        ]
      );
      // $data['image'] = 'https://firebasestorage.googleapis.com/v0/b/tattoo-f01b9.appspot.com/o/'.$fileName.'?alt=media';
    $data['icon'] = $uploadedFile->info()['mediaLink'];
    }
    if ($_FILES['grayimage']['tmp_name'] != '') {
      $fileName = "events" . rand() . time() . $_FILES['grayimage']['name'];
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['grayimage']['tmp_name']),
        [
          'name' => $fileName,
  'predefinedAcl' => 'publicRead'
        ]
      );
      // $data['image'] = 'https://firebasestorage.googleapis.com/v0/b/tattoo-f01b9.appspot.com/o/'.$fileName.'?alt=media';
    $data['grayIcon'] = $uploadedFile->info()['mediaLink'];
    }

    $response = $this->common->addnewdatamodel('Category', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));		
	}
	public function editcategory()
	{
		$id = $this->uri->segment(3);
    $data['id'] = $id;
		$data['category'] = $this->common->readdatadocument('Groups', $id);
		$this->template->template_render('addcategory', $data);
	}
  public function viewcategory()
	{
		$id = $this->uri->segment(3);
    $data['id'] = $id;
		$data['category'] = $this->common->readdatadocument('Groups', $id);
		$this->template->template_render('viewgroup', $data);
	}
  
	public function vieworder()
	{
		$id = $this->uri->segment(3);
    $data['id'] = $id;
    $data['prolist'] = $this->common->readdatafromcollectionwhereclause("Users",'userRole', '==', 'Pro');;
    $data['ride'] = $this->common->readdatadocument('Services', $id);
		$this->template->template_render('vieworder', $data);
	}
  public function getAwaitedOrders() {
    $notifications=$this->common->readdatafromcollectionwhereclause("Services",'status', '==', 'awaited');;
    echo json_encode($notifications);
}
  public function addserviceprovider($id){

		$product=$this->common->readdatadocument("Services",$id);
    $d['serviceProId']=$this->input->post('serviceProId');
    $userinfo=$this->common->readdatadocument("Users", $d['serviceProId']);	
    $d['status']='assigned';
    $d['assignedDate']=time()*1000;

    $j['message']="Admin has been Assigned New Task";
    $j['senderID']="";
    $j['serviceId']=$id;
    $j['userID']=$d['serviceProId'];
    $j['time']=time()*1000;
    $j['title']="New Job Assigned";
    $j['type']='assigned';
    if($userinfo['token'] !=""){
      $title="New Job Assigned";
      $result = $this->firebase->sendPushNotification($userinfo['token'], $title, $j['message'], $j);

    }
    $key=rand().time().rand();
    $this->common->adddatamodel("Notifications",$key,$d);
    $this->common->updatedatamodel("Services", $id, $d);
    $this->session->set_flashdata('successmessage', 'Service Has been Assigned');
				redirect(base_url().'dashboard/vieworder/'.$id);

  
  }
  
	public function editsubcategory()
	{
		$id = $this->uri->segment(3);
    $data['id'] = $id;
    $data['catelist'] = $this->common->readdatafromcollectionwhereclause('Category');
    $data['category'] = $this->common->readdatadocument('SubCategory', $id);
		$this->template->template_render('addsubcategory', $data);
	}
	public function updatecategory()
	{
    $data = $this->input->post();
    /*
    if ($_FILES['image']['tmp_name'] != '') {
      $fileName = "events" . rand() . time() . $_FILES['image']['name'];
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['image']['tmp_name']),
        [
          'name' => $fileName,
  'predefinedAcl' => 'publicRead'
        ]
      );
      // $data['image'] = 'https://firebasestorage.googleapis.com/v0/b/tattoo-f01b9.appspot.com/o/'.$fileName.'?alt=media';
    $data['icon'] = $uploadedFile->info()['mediaLink'];
    }
    if ($_FILES['grayimage']['tmp_name'] != '') {
      $fileName = "events" . rand() . time() . $_FILES['grayimage']['name'];
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['grayimage']['tmp_name']),
        [
          'name' => $fileName,
  'predefinedAcl' => 'publicRead'
        ]
      );
      // $data['image'] = 'https://firebasestorage.googleapis.com/v0/b/tattoo-f01b9.appspot.com/o/'.$fileName.'?alt=media';
    $data['grayIcon'] = $uploadedFile->info()['mediaLink'];
    }
*/

		$response = $this->common->updatedatamodel('Groups', $data['id'], $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Groups updated successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
	}

  public function deletecategory()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('Groups', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Group deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
	}

  
  public function deletesubcategory()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('Feedback', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Feedback deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/subcategories'));
	}
}