<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Rides extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
    $this->load->model('geofence_model');
  }
  
  public function settings()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");
    
    
    $this->template->template_render('settings', $data);
  }

  

  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Data has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }



  public function index()
	{

    $rides = $this->common->readdatafromcollectionbetween("Rides");
    foreach($rides as $key => $ride) {
      $driverId = $ride['driverId'];
      $userId = $ride['userId'];
      $driver = $this->common->readdatadocument('Users', $driverId);
      $user = $this->common->readdatadocument('Users', $userId);
      $rides[$key]['driver'] = $driver;
      $rides[$key]['user'] = $user;
    }
    $data["rides"] = $rides;
		
		$this->template->template_render('rides_management', $data);
	}

  public function income()
	{

    $rides = $this->common->readdatafromcollectionbetween("Rides");
    $totalRides = count($rides);
    $totalIncome = 0;
    $totalPayouts = 0;
    $netProfit = 0;
    foreach($rides as $key => $ride) {
      $totalIncome += (int)$ride['rent'];
      $totalPayouts += (int)$ride['driverShare'];
      $netProfit += (int)$ride['appShare'];
    }
    $data["rides"] = $rides;

    $data["totalRides"] = $totalRides;
    $data["totalIncome"] = $totalIncome;
    $data["totalPayouts"] = $totalPayouts;
    $data["netProfit"] = $netProfit;
		
		$this->template->template_render('income', $data);
	}



}