<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calendly Connect</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        * {
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #0069ff 0%, #0052cc 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 15px;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            -webkit-tap-highlight-color: transparent;
        }

        .center-box {
            max-width: 440px;
            width: 100%;
            padding: 40px 30px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            text-align: center;
        }

        .logo-container {
            width: 80px;
            height: 80px;
            margin: 0 auto 20px;
            background: linear-gradient(135deg, #0069ff 0%, #0052cc 100%);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 8px 20px rgba(0, 105, 255, 0.4);
        }

        .logo-container img {
            width: 45px;
            height: 45px;
            filter: brightness(0) invert(1);
        }

        h4 {
            color: #2d3748;
            font-weight: 700;
            font-size: 24px;
            margin-bottom: 12px;
        }

        .subtitle {
            color: #718096;
            font-size: 15px;
            line-height: 1.6;
            margin-bottom: 30px;
        }

        .btn-connect {
            background: linear-gradient(135deg, #0069ff 0%, #0052cc 100%);
            border: none;
            padding: 14px 40px;
            font-size: 16px;
            font-weight: 600;
            border-radius: 12px;
            color: white;
            width: 100%;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 105, 255, 0.4);
            cursor: pointer;
            -webkit-appearance: none;
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
        }

        .btn-connect:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 105, 255, 0.5);
            color: white;
        }

        .btn-connect:active {
            transform: translateY(0);
        }

        .modal-content {
            border-radius: 20px;
            border: none;
            padding: 30px 20px;
        }

        .modal-header {
            border: none;
            padding-bottom: 10px;
        }

        .modal-title {
            color: #2d3748;
            font-weight: 700;
            font-size: 22px;
            width: 100%;
            text-align: center;
        }

        .form-group {
            text-align: left;
            margin-bottom: 20px;
        }

        .form-group label {
            color: #4a5568;
            font-weight: 600;
            font-size: 14px;
            margin-bottom: 8px;
            display: block;
        }

        .form-control {
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            padding: 12px 15px;
            font-size: 15px;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: #0069ff;
            box-shadow: 0 0 0 3px rgba(0, 105, 255, 0.1);
        }

        .btn-submit {
            background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
            border: none;
            padding: 14px;
            font-size: 16px;
            font-weight: 600;
            border-radius: 12px;
            color: white;
            width: 100%;
            margin-top: 10px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(72, 187, 120, 0.4);
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(72, 187, 120, 0.5);
            background: linear-gradient(135deg, #38a169 0%, #2f855a 100%);
        }

        .close {
            position: absolute;
            right: 20px;
            top: 20px;
            font-size: 28px;
            opacity: 0.5;
            transition: opacity 0.3s ease;
        }

        .close:hover {
            opacity: 0.8;
        }

        /* Mobile optimizations */
        @media (max-width: 576px) {
            body {
                padding: 10px;
            }

            .center-box {
                padding: 30px 20px;
            }

            h4 {
                font-size: 22px;
            }

            .subtitle {
                font-size: 14px;
            }

            .modal-content {
                padding: 25px 15px;
            }

            .modal-title {
                font-size: 20px;
            }

            .logo-container {
                width: 70px;
                height: 70px;
            }

            .logo-container img {
                width: 40px;
                height: 40px;
            }
        }

        /* Very small screens */
        @media (max-width: 360px) {
            .center-box {
                padding: 25px 15px;
            }

            .btn-connect,
            .btn-submit {
                padding: 12px;
                font-size: 15px;
            }
        }
    </style>
</head>

<body>

    <div class="center-box">
        <div class="logo-container">
            <img src="https://cdn-icons-png.flaticon.com/512/3209/3209265.png" alt="Calendly Logo">
        </div>
        <h4>Calendly Integration</h4>
        <p class="subtitle">Connect your Calendly account to sync your scheduling data seamlessly.</p>

        <button class="btn btn-connect" id="openModalBtn" type="button">
            Connect Calendly Account
        </button>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="credentialModal" tabindex="-1" role="dialog" aria-labelledby="credentialModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="credentialModalLabel">Calendly Credentials</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="credForm" method="POST" action="<?= base_url('calendly/connect_start') ?>">
                        <div class="form-group">
                            <label for="client_id">Client ID</label>
                            <input type="text" class="form-control" id="client_id" name="client_id" placeholder="Enter your Client ID" required>
                        </div>
                        <div class="form-group">
                            <label for="client_secret">Client Secret</label>
                            <input type="text" class="form-control" id="client_secret" name="client_secret" placeholder="Enter your Client Secret" required>
                        </div>

                        <!-- Get ID from URL parameter and set it directly -->
                        <input type="hidden" class="form-control" name="lawId" id="lawId"
                            value="<?= isset($_GET['id']) ? $_GET['id'] : '' ?>" required>

                        <button class="btn btn-submit" type="submit">Start Authorization</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Get lawId from URL parameter
            var lawId = $('#lawId').val();
            console.log('Law ID from URL:', lawId);

            if (!lawId) {
                console.warn('No ID parameter found in URL');
            }

            // iOS WebView Modal Fix - Multiple methods for maximum compatibility
            var modalBtn = $('#openModalBtn');

            // Method 1: Standard click handler
            modalBtn.on('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                console.log('Button clicked - opening modal');
                $('#credentialModal').modal('show');
            });

            // Method 2: Touch events for iOS
            modalBtn.on('touchend', function(e) {
                e.preventDefault();
                console.log('Touch end - opening modal');
                $('#credentialModal').modal('show');
            });

            // Method 3: Force pointer events
            modalBtn.css({
                'pointer-events': 'auto',
                '-webkit-user-select': 'none',
                'user-select': 'none'
            });

            // Debug modal events
            $('#credentialModal').on('show.bs.modal', function(e) {
                console.log('Modal show event triggered');
            });

            $('#credentialModal').on('shown.bs.modal', function(e) {
                console.log('Modal shown successfully');
            });

            $('#credentialModal').on('hide.bs.modal', function(e) {
                console.log('Modal hide event triggered');
            });
        });
    </script>

</body>

</html>