<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calendly Connected Successfully</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <style>
        * {
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #0069ff 0%, #0052cc 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 15px;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
        }

        .success-box {
            max-width: 440px;
            width: 100%;
            padding: 40px 30px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            text-align: center;
        }

        .success-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 20px;
            background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 8px 20px rgba(72, 187, 120, 0.4);
        }

        .success-icon svg {
            width: 45px;
            height: 45px;
            color: white;
        }

        h4 {
            color: #2d3748;
            font-weight: 700;
            font-size: 24px;
            margin-bottom: 12px;
        }

        .success-message {
            color: #718096;
            font-size: 15px;
            line-height: 1.6;
            margin-bottom: 30px;
        }

        .btn-close {
            background: linear-gradient(135deg, #0069ff 0%, #0052cc 100%);
            border: none;
            padding: 14px 40px;
            font-size: 16px;
            font-weight: 600;
            border-radius: 12px;
            color: white;
            width: 100%;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 105, 255, 0.4);
            text-decoration: none;
            display: inline-block;
        }

        .btn-close:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 105, 255, 0.5);
            color: white;
            text-decoration: none;
        }

        /* Mobile optimizations */
        @media (max-width: 576px) {
            body {
                padding: 10px;
            }

            .success-box {
                padding: 30px 20px;
            }

            h4 {
                font-size: 22px;
            }

            .success-message {
                font-size: 14px;
            }

            .success-icon {
                width: 70px;
                height: 70px;
            }

            .success-icon svg {
                width: 40px;
                height: 40px;
            }
        }

        @media (max-width: 360px) {
            .success-box {
                padding: 25px 15px;
            }

            .btn-close {
                padding: 12px;
                font-size: 15px;
            }
        }
    </style>
</head>

<body>

    <div class="success-box">
        <div class="success-icon">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7" />
            </svg>
        </div>
        <h4>Successfully Connected!</h4>
        <p class="success-message">
            Your Calendly account has been connected successfully. You can now close this window and return to your application.
        </p>
        <button class="btn btn-close" onclick="window.close()">
            Close Window
        </button>
    </div>

</body>

</html>