<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Error - MyCase Connect</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <style>
        * {
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 15px;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            margin: 0;
        }

        .error-card {
            max-width: 440px;
            width: 100%;
            padding: 50px 30px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            text-align: center;
            animation: slideUp 0.5s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .error-icon-container {
            width: 100px;
            height: 100px;
            margin: 0 auto 25px;
            background: linear-gradient(135deg, #fc8181 0%, #f56565 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 10px 30px rgba(252, 129, 129, 0.4);
            animation: shake 0.6s ease-out 0.2s both;
            position: relative;
        }

        @keyframes shake {

            0%,
            100% {
                transform: translateX(0);
            }

            10%,
            30%,
            50%,
            70%,
            90% {
                transform: translateX(-5px);
            }

            20%,
            40%,
            60%,
            80% {
                transform: translateX(5px);
            }
        }

        .error-icon-container::before {
            content: '!';
            font-size: 50px;
            font-weight: 700;
            color: white;
            line-height: 1;
        }

        h4 {
            color: #2d3748;
            font-weight: 700;
            font-size: 26px;
            margin-bottom: 15px;
            animation: fadeIn 0.6s ease-out 0.4s both;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        .error-message {
            color: #718096;
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 30px;
            padding: 15px;
            background: #f7fafc;
            border-radius: 10px;
            border-left: 4px solid #fc8181;
            animation: fadeIn 0.6s ease-out 0.6s both;
        }

        .btn-back {
            display: inline-block;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 14px 40px;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            animation: fadeIn 0.6s ease-out 0.8s both;
        }

        .btn-back:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
            color: white;
            text-decoration: none;
        }

        .btn-back:active {
            transform: translateY(0);
        }

        .btn-back:focus {
            outline: none;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4), 0 0 0 3px rgba(102, 126, 234, 0.2);
        }

        .error-code {
            display: inline-block;
            background: #fff5f5;
            color: #c53030;
            padding: 6px 16px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
            margin-bottom: 20px;
            animation: fadeIn 0.6s ease-out 0.3s both;
        }

        /* Mobile optimizations */
        @media (max-width: 576px) {
            body {
                padding: 10px;
            }

            .error-card {
                padding: 40px 20px;
            }

            h4 {
                font-size: 22px;
            }

            .error-message {
                font-size: 15px;
                padding: 12px;
            }

            .error-icon-container {
                width: 85px;
                height: 85px;
            }

            .error-icon-container::before {
                font-size: 45px;
            }

            .btn-back {
                padding: 12px 35px;
                font-size: 15px;
            }
        }

        /* Very small screens */
        @media (max-width: 360px) {
            .error-card {
                padding: 35px 15px;
            }

            h4 {
                font-size: 20px;
            }

            .error-message {
                font-size: 14px;
            }

            .btn-back {
                padding: 12px 30px;
                font-size: 14px;
            }
        }
    </style>
</head>

<body>
    <div class="error-card">
        <span class="error-code">Error</span>

        <div class="error-icon-container"></div>

        <h4>Oops! Something went wrong</h4>

        <div class="error-message">
            <?php echo isset($message) ? htmlspecialchars($message) : 'An unknown error occurred. Please try again or contact support if the problem persists.'; ?>
        </div>

        <a href="<?= base_url() ?>" class="btn-back">Go Back Home</a>
    </div>
</body>

</html>