<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MyCase Connected Successfully</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <style>
        * {
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 15px;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            margin: 0;
        }

        .success-card {
            max-width: 440px;
            width: 100%;
            padding: 50px 30px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            text-align: center;
            animation: slideUp 0.5s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .success-icon-container {
            width: 100px;
            height: 100px;
            margin: 0 auto 25px;
            background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 10px 30px rgba(72, 187, 120, 0.4);
            animation: scaleIn 0.6s ease-out 0.2s both;
        }

        @keyframes scaleIn {
            from {
                transform: scale(0);
            }

            to {
                transform: scale(1);
            }
        }

        .success-icon-container img {
            width: 55px;
            height: 55px;
            filter: brightness(0) invert(1);
        }

        .checkmark {
            width: 100px;
            height: 100px;
            margin: 0 auto 25px;
            position: relative;
        }

        .checkmark-circle {
            width: 100px;
            height: 100px;
            background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 10px 30px rgba(72, 187, 120, 0.4);
            animation: scaleIn 0.6s ease-out 0.2s both;
        }

        .checkmark-icon {
            width: 50px;
            height: 50px;
            stroke: white;
            stroke-width: 3;
            stroke-linecap: round;
            stroke-linejoin: round;
            fill: none;
        }

        .checkmark-check {
            stroke-dasharray: 50;
            stroke-dashoffset: 50;
            animation: drawCheck 0.5s ease-out 0.7s forwards;
        }

        @keyframes drawCheck {
            to {
                stroke-dashoffset: 0;
            }
        }

        h4 {
            color: #2d3748;
            font-weight: 700;
            font-size: 28px;
            margin-bottom: 15px;
            animation: fadeIn 0.6s ease-out 0.4s both;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        .success-message {
            color: #718096;
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 0;
            animation: fadeIn 0.6s ease-out 0.6s both;
        }

        .success-badge {
            display: inline-block;
            background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
            margin-top: 25px;
            animation: fadeIn 0.6s ease-out 0.8s both;
        }

        /* Mobile optimizations */
        @media (max-width: 576px) {
            body {
                padding: 10px;
            }

            .success-card {
                padding: 40px 20px;
            }

            h4 {
                font-size: 24px;
            }

            .success-message {
                font-size: 15px;
            }

            .success-icon-container,
            .checkmark,
            .checkmark-circle {
                width: 85px;
                height: 85px;
            }

            .success-icon-container img {
                width: 45px;
                height: 45px;
            }

            .checkmark-icon {
                width: 45px;
                height: 45px;
            }
        }

        /* Very small screens */
        @media (max-width: 360px) {
            .success-card {
                padding: 35px 15px;
            }

            h4 {
                font-size: 22px;
            }

            .success-message {
                font-size: 14px;
            }
        }
    </style>
</head>

<body>
    <div class="success-card">
        <div class="checkmark">
            <div class="checkmark-circle">
                <svg class="checkmark-icon" viewBox="0 0 52 52">
                    <path class="checkmark-check" d="M14 27l10 10 20-20" />
                </svg>
            </div>
        </div>

        <h4>Successfully Connected!</h4>
        <p class="success-message">Your MyCase account has been linked Successfully.</p>

    </div>
</body>

</html>