<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>MyCase Connect</title>
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
	<style>
		* {
			box-sizing: border-box;
		}

		body {
			background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
			min-height: 100vh;
			display: flex;
			align-items: center;
			justify-content: center;
			padding: 15px;
			font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
			margin: 0;
		}

		.center-box {
			max-width: 440px;
			width: 100%;
			padding: 40px 30px;
			background: white;
			border-radius: 20px;
			box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
			text-align: center;
		}

		.logo-container {
			width: 80px;
			height: 80px;
			margin: 0 auto 20px;
			background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
			border-radius: 20px;
			display: flex;
			align-items: center;
			justify-content: center;
			box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
		}

		.logo-container img {
			width: 45px;
			height: 45px;
			filter: brightness(0) invert(1);
		}

		h4 {
			color: #2d3748;
			font-weight: 700;
			font-size: 24px;
			margin-bottom: 12px;
		}

		.subtitle {
			color: #718096;
			font-size: 15px;
			line-height: 1.6;
			margin-bottom: 30px;
		}

		.btn-connect {
			background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
			border: none;
			padding: 14px 40px;
			font-size: 16px;
			font-weight: 600;
			border-radius: 12px;
			color: white;
			width: 100%;
			transition: all 0.3s ease;
			box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
			display: inline-block;
			text-decoration: none;
		}

		.btn-connect:hover {
			transform: translateY(-2px);
			box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
			color: white;
			text-decoration: none;
		}

		.btn-connect:active {
			transform: translateY(0);
		}

		.btn-connect:focus {
			outline: none;
			box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4), 0 0 0 3px rgba(102, 126, 234, 0.2);
		}

		/* Mobile optimizations */
		@media (max-width: 576px) {
			body {
				padding: 10px;
			}

			.center-box {
				padding: 30px 20px;
			}

			h4 {
				font-size: 22px;
			}

			.subtitle {
				font-size: 14px;
			}

			.logo-container {
				width: 70px;
				height: 70px;
			}

			.logo-container img {
				width: 40px;
				height: 40px;
			}

			.btn-connect {
				padding: 12px 30px;
				font-size: 15px;
			}
		}

		/* Very small screens */
		@media (max-width: 360px) {
			.center-box {
				padding: 25px 15px;
			}

			h4 {
				font-size: 20px;
			}

			.btn-connect {
				padding: 12px 25px;
				font-size: 14px;
			}
		}
	</style>
</head>

<body>

	<div class="center-box">
		<div class="logo-container">
			<img src="https://cdn-icons-png.flaticon.com/512/3597/3597075.png" alt="MyCase Logo">
		</div>
		<h4>MyCase Integration</h4>
		<p class="subtitle">Connect your attorney MyCase account to continue.</p>
		<a href="<?php echo base_url('mycase/connect') ?>" class="btn-connect">
			Connect MyCase Account
		</a>
	</div>

</body>

</html>