<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Chat extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('form');
		$this->load->library('session');
		$this->load->model('common');
		$this->load->library(array('form_validation', 'template'));
	}

	public function index()
	{
		$data['admin'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "admin");
		$data["adminId"] = array_keys($data['admin'])[0];
		$data['myrequest'] = $this->common->readdatafromcollectionwhereclause("MyRequests");
		// echo "<pre>";
		// print_r($data);
		// echo "</pre>";
		$this->template->template_render('chat', $data);
	}

	public function clientchat()
	{
		$data['admin'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "admin");
		$data["adminId"] = array_keys($data['admin'])[0];
		$chats = $this->common->readdatafromcollectionwhereclause("AdminChats");
		foreach ($chats as $chatId => $chat) {
			if ($chat['lastMessage']['fromID'] == $data["adminId"]) {
				if (isclient($chat['lastMessage']['toID'])) {
					$data['myrequest'][$chatId] = $chat;
				}
			} else {
				if (isclient($chat['lastMessage']['fromID'])) {
					$data['myrequest'][$chatId] = $chat;
				}
			}
		}
		// $data['myrequest'] = $this->common->readdatafromcollectionwhereclause("AdminChats");
		$this->template->template_render('clientchat', $data);
	}
	public function deleteclientchat($id)
	{
		$data = $this->common->readdatafromcollectionwhereclause("AdminChats", "conversationId", "=", $id);
		foreach ($data as $d => $l) {
			$this->common->deletedatamodel("AdminChats", $d);
		}
		$this->common->deletedatamodel("AdminChats", $id);
		$this->session->set_flashdata('successmessage', 'Chat has been removed successfully..');
		redirect('chat/clientchat');
	}
	public function clientdetailedchat($id)
	{
		$data = $this->common->readdatadocument("AdminChats", $id);
		$data['admin'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "admin");
		$data["adminId"] = array_keys($data['admin'])[0];
		$adminId = $data["adminId"];
		$data["conversation"] = $this->common->readdatacollection("AdminChats", "conversations", $id);
		foreach ($data["participants"] as $userId => $value) {
			if ($userId != $adminId) {
				$data["userId"] = $userId;
			}
		}
		$data["chatId"] = $id;
		$data["userName"] = $this->common->readclientname($data["userId"]);
		$data["userImage"] = $this->common->readclientImage($data["userId"]);
		$this->template->template_render('clientchatdetails', $data);
	}

	public function addnewgroup()
	{
		$d = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "admin");
		$INSERTEDiD = time();

		$data['groupname'] = $this->input->post('groupname');
		$member = $this->input->post('members');
		$arrayName = array();
		$data["adminId"] = array_keys($d)[0];
		$arrayName[$data["adminId"]] = false;
		for ($i = 0; $i < count($member); $i++) {
			//echo 
			$arrayName[$member[$i]] = true;
			//array_push($shna,$arrayName);

		}

		$data['participants'] = $arrayName;
		$data["adminId"] = array_keys($d)[0];
		$data['createdBy'] = $INSERTEDiD;
		$data['conversationId'] = $INSERTEDiD;
		$data['lastmessage'] = "Admin Created this group";

		//$this->common->adddatamodel("AdminGroup",$INSERTEDiD,$data);
		$papi = array();

		$papi['content'] = "Admin Added you in this group";

		$papi['fromID'] = $data["adminId"];
		$papi['messageId'] = $INSERTEDiD;
		$papi['timestamp'] = $INSERTEDiD;
		$papi['type'] = "text";

		$jawan['lastMessage'] = $papi;

		$jawan['chatType'] = "adminchat";
		$jawan['groupName'] = $data['groupname'];
		$jawan['participants'] = $arrayName;
		$this->common->adddatamodel("ClientChats", $INSERTEDiD, $jawan);

		$this->common->adddatamodelnexted("ClientChats", $INSERTEDiD, 'Conversations', $INSERTEDiD, $papi);


		redirect(base_url() . 'Chat/groupchat');
	}

	public function groupchat()
	{
		$data['admin'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "admin");
		$data['userlist'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "!=", "admin");


		$data["adminId"] = array_keys($data['admin'])[0];
		$data['myrequest'] = $this->common->readdatafromcollectionwhereclause("ClientChats", "chatType", "=", "adminchat");
		$this->template->template_render('groupchat', $data);
	}

	public function teamchat()
	{
		$data['admin'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "admin");
		$data["adminId"] = array_keys($data['admin'])[0];
		$data['myrequest'] = $this->common->readdatafromcollectionwhereclause("AdminChats");
		$this->template->template_render('teamchat', $data);
	}

	public function deletegroupchat($id)
	{
		$data = $this->common->nextedreaddatafromcollectionwhereclause("ClientChats",  $id, "Conversations");
		foreach ($data as $key => $value) {
			$this->common->nexteddeletedatamodel("ClientChats", $id, "Conversations", $key);
		}
		$this->session->set_flashdata('successmessage', 'Chat has been removed successfully..');
		redirect('Chat/groupchat');
	}
	public function deletechat($id)
	{


		$data = $this->common->readdatafromcollectionwhereclause("AdminChats", "conversationId", "=", $id);

		foreach ($data as $d => $l) {

			$this->common->deletedatamodel("AdminChats", $d);
		}
		$this->common->deletedatamodel("AdminChats", $id);

		$this->session->set_flashdata('successmessage', 'Chat has been removed successfully..');
		redirect('chat');
	}

	public function detailedchat($id)
	{
		$data = $this->common->readdatadocument("AdminChats", $id);
		$data['admin'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "admin");
		$data["adminId"] = array_keys($data['admin'])[0];
		$adminId = $data["adminId"];
		$data["conversation"] = $this->common->readdatacollection("AdminGroupChats", "Conversations", $id);
		foreach ($data["participants"] as $userId => $value) {
			if ($userId != $adminId) {
				$data["userId"] = $userId;
			}
		}
		$data["chatId"] = $id;
		$data["userName"] = $this->common->readclientname($data["userId"]);
		$data["userImage"] = $this->common->readclientImage($data["userId"]);


		$this->template->template_render('chatdetails', $data);
	}
	//detailedgroupchat
	public function detailedgroupchat($id)
	{
		//$data = $this->common->readdatadocument("AdminChats", $id);
		$data['admin'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "admin");
		$data["adminId"] = array_keys($data['admin'])[0];
		$adminId = $data["adminId"];
		$data["conversation"] = $this->common->readdatacollection("ClientChats", "Conversations", $id);

		$data["chatId"] = $id;
		// 		echo "<pre>";
		// 		print_r($data["conversation"]);
		// 		echo "</pre>";
		// exit;

		$this->template->template_render('chatgroupdetails', $data);
	}

	public function Chatdetail($id)

	{
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$myid = $this->session->userdata('userdata')['user_id'];


		$support = $db->getReference("chat/" . $myid . '/' . $id)->getSnapshot()->getValue();
		$data['user'] = $db->getReference("User/" . $id)->getSnapshot()->getValue();
		$data['reciver_id'] = $id;
		$data['myid'] = $myid;
		// 	echo "<pre>";
		// 	print_r($data);
		// 	echo "</pre>";

		$this->load->view('bussiness/chat-detail', $data);
	}
}
