<?php
defined('BASEPATH') or exit('No direct script access allowed');

class jobs extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->model('common');
    $this->load->helper(array('form', 'url', 'string'));
    $this->load->library('form_validation');
    $this->load->library('session');
  }

  public function deletejob($id)   
	{
		$this->common->deletedatamodel("Jobs", $id);
		$this->session->set_flashdata('successmessage', 'Jobs Deleted');
		redirect('Jobs');
	}
	
  public function index()
  {
    $data['travelslist'] =  $this->common->readdatafromcollectionwhereclause("Jobs");
   

    $this->template->template_render('job_management', $data);
  }

  public function add()
  {
    $this->template->template_render('job_add');
  }
  
  public function adddata()
  {
    $data=$this->input->post();
    // echo "<pre>";
    // var_dump($data);
    if($data['isActive']=="true"){
      $data['isActive']=true;
    }else{
      $data['isActive']=false;
    }
    $data['jobDate']=strtotime($data['jobDate'])*1000; 
    // print_r($data);
    // echo "</pre>";
    $travelId = time();
    $response = $this->common->adddatamodel("Jobs", $travelId, $data);
    if ($response) {
      $this->session->set_flashdata('successmessage', 'New Jobs added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Error in creating new Jobs..');
    }
    redirect('Jobs');
  }

  public function inserttravel()
  {
    
    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    $data = $this->input->post();
    $data['lat'] = (float)$this->input->post('lat');
    $data['lng'] = (float)$this->input->post('lng');
    
    $totalfiles = count($_FILES['images']['name']);
    for( $i=0 ; $i < $totalfiles ; $i++ ) {
      if ($_FILES['images']['tmp_name'][$i] != '') {
        $uploadedFile = $defaultBucket->upload(
          file_get_contents($_FILES['images']['tmp_name'][$i]),
          [
            'name' => "travelImage" . rand() . time() . $_FILES['images']['name'][$i],
          ]
        );
        $data['images'][$i] = $uploadedFile->info()['mediaLink'];
      }
    }
    
    if (isset($_POST)) {
      $travelId = time();
      $response = $this->common->adddatamodel("Travels", $travelId, $data);
      if ($response) {
        $this->session->set_flashdata('successmessage', 'New travel added successfully..');
      } else {
        $this->session->set_flashdata('warningmessage', 'Error in creating new travel..');
      }
      redirect('travel');
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
      redirect('travel');
    }
  }

  public function editjob()
  {
    $id = $this->uri->segment(3);
    $data['id'] = $id;
    $data['traveldetails'] = $this->common->readdatadocument("Jobs", $id);
    $this->template->template_render('editTravel', $data);
  }

  //viewjob
  public function viewjob()
  {
    $id = $this->uri->segment(3);
    $data['id'] = $id;
    $data['traveldetails'] = $this->common->readdatadocument("Jobs", $id);
    $this->template->template_render('viewjobs', $data);
  }
  public function updatejobdata()
  {
    $id = $this->uri->segment(3);
    $data = $this->input->post();
    $data['jobLatitude'] = (float)$this->input->post('jobLatitude');
    $data['jobLongitute'] = (float)$this->input->post('jobLongitute');
    if($data['isActive']=="true"){
      $data['isActive']=true;
    }else{
      $data['isActive']=false;
    }
    $data['jobDate']=strtotime($data['jobDate'])*1000; 
  
    if (isset($_POST)) {
      $response = $this->common->updatedatamodel("Jobs", $id, $data);
      if ($response) {
        $this->session->set_flashdata('successmessage', 'travel updated successfully..');
        redirect('jobs');
      } else {
        $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
        redirect('jobs');
      }
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
      redirect('jobs');
    }
  }
}
