<script>
      // This example requires the Places library. Include the libraries=places
      // parameter when you first load the API. For example:
      // <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places">

      function initMap() {
        var map = new google.maps.Map(document.getElementById('map'), {
          center: {lat: -33.8688, lng: 151.2195},
          zoom: 13
        });
        var card = document.getElementById('pac-card');
        var input = document.getElementById('pac-input');
        var types = document.getElementById('type-selector');
        var strictBounds = document.getElementById('strict-bounds-selector');

        map.controls[google.maps.ControlPosition.TOP_RIGHT].push(card);

        var autocomplete = new google.maps.places.Autocomplete(input);

        // Bind the map's bounds (viewport) property to the autocomplete object,
        // so that the autocomplete requests use the current map bounds for the
        // bounds option in the request.
        autocomplete.bindTo('bounds', map);

        // Set the data fields to return when the user selects a place.
        autocomplete.setFields(
            ['address_components', 'geometry', 'icon', 'name']);

        var infowindow = new google.maps.InfoWindow();
        var infowindowContent = document.getElementById('infowindow-content');
        infowindow.setContent(infowindowContent);
        var marker = new google.maps.Marker({
          map: map,
          anchorPoint: new google.maps.Point(0, -29)
        });

        autocomplete.addListener('place_changed', function() {
          infowindow.close();
          marker.setVisible(false);
          var place = autocomplete.getPlace();
                       
          
          if (!place.geometry) {
            // User entered the name of a Place that was not suggested and
            // pressed the Enter key, or the Place Details request failed.
            window.alert("No details available for input: '" + place.name + "'");
            return;
          }

          // If the place has a geometry, then present it on a map.
          if (place.geometry.viewport) {
            map.fitBounds(place.geometry.viewport);
          } else {
            map.setCenter(place.geometry.location);
            map.setZoom(17);  // Why 17? Because it looks good.
          }
          marker.setPosition(place.geometry.location);
          marker.setVisible(true);

          var address = '';
          console.log(place.address_components)
          if (place.address_components) {
              var latitude = place.geometry.location.lat();
        var longitude = place.geometry.location.lng();
        console.log(latitude);
        console.log(longitude);
        document.getElementById("lat").value = latitude;
        document.getElementById("lng").value = longitude;
        
        //infodetail
    //    $("#lat").val(latitude);
      //   $("#lng").val(longitude);
        
              
            address = [
              (place.address_components[0] && place.address_components[0].short_name || ''),
              (place.address_components[1] && place.address_components[1].short_name || ''),
              (place.address_components[2] && place.address_components[2].short_name || '')
            ].join(' ');
          }
            document.getElementById("infodetail").value = place.name;
          infowindowContent.children['place-icon'].src = place.icon;
          infowindowContent.children['place-name'].textContent = place.name;
          infowindowContent.children['place-address'].textContent = address;
          infowindow.open(map, marker);
        });

        // Sets a listener on a radio button to change the filter type on Places
        // Autocomplete.
        function setupClickListener(id, types) {
          var radioButton = document.getElementById(id);
          radioButton.addEventListener('click', function() {
            autocomplete.setTypes(types);
          });
        }

        setupClickListener('changetype-all', []);
        setupClickListener('changetype-address', ['address']);
        setupClickListener('changetype-establishment', ['establishment']);
        setupClickListener('changetype-geocode', ['geocode']);

        document.getElementById('use-strict-bounds')
            .addEventListener('click', function() {
              console.log('Checkbox clicked! New state=' + this.checked);
              autocomplete.setOptions({strictBounds: this.checked});
            });
      }
    </script>

   </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDfRI5hac8jwDvEQ1k2S5jfNEiNa9vcWhE&libraries=places&callback=initMap"
        async defer></script>

<div id="map"></div>
<main class="main-wrapper">
    <div class="main-content">
      <!-- orders section -->
     
    <div class="my-2">
        <div class="container">
            <div class="row">
              <div class="col-md-12 my-2">
               <p class="fadd">Job Update</p>
                <div class="row mb-2 mt-5">
                  <div class="col-md-12 my-2">
                    <form action="<?php echo base_url().'Jobs/updatejobdata/'.$id ?>" method="post">
                      <div class="my-2 row justify-content-center">
                        <div class="col-md-6 my-2">
                          <label for="Email" class="label">Job Name</label>
                          <input
                            class="form-control formInp py-3"
                            type="text"
                            name="jobName"
                            value="<?php echo $traveldetails['jobName']; ?>"
                            required
                            placeholder="Job Name"
                          />
                        </div>
                      
                      </div>
                      <div class="my-2 row justify-content-center">
                        <div class="col-md-6 my-2">
                          <label for="Email" class="label">Job Active Status</label>
                          <select
                            class="form-control formInp py-3"
                           
                            name="isActive"
                            required

                          />
                          <option <?php if($traveldetails['isActive']==true){echo 'checked';} ?> value="true">True</option>
                          <option <?php if($traveldetails['isActive']==false){echo 'checked';} ?> value="false">False</option>
                        </select>
                        </div>
                      
                      </div>
                      <div class="my-2 row justify-content-center">
                        <div class="col-md-6 my-2">
                          <label for="Date" class="label">Date</label>
                          <input
                            class="form-control formInp py-3"
                            type="date"
                            name="jobDate"
                           value="<?php echo date("Y-m-d",$traveldetails['jobDate']/1000); ?>"
                            placeholder="Job Start Date"
                          />
                        </div>
                      
                      </div>
                      <div class="my-2 row justify-content-center">
                        <div class="col-md-6 my-2">
                          <label for="Date" class="label">Job Hourse (In hourse)</label>
                          <input
                            class="form-control formInp py-3"
                            type="number"
                            step="0.01"
                             value="<?php echo $traveldetails['jobHours']; ?>"
                            name="jobHours"
                            placeholder="Job Break Time"
                          />
                        </div>
                      
                      </div>
                     
                      <div class="my-2 row justify-content-center">
                        <div class="col-md-6 my-2">
                          <label for="Date" class="label">Brake Time (In Mintues)</label>
                          <input
                            class="form-control formInp py-3"
                            type="number"
                            name="jobBreakTime"
                            value="<?php echo $traveldetails['jobBreakTime']; ?>"
                            placeholder="Job Break Time"
                          />
                        </div>
                      
                      </div>
                      
                      <div class="my-2 row justify-content-center">
                        
                        <div class="col-md-6 my-2 ">
                          <label for="Email" class="label">Loction</label>
                          <input
                            class="form-control formInp py-3"
                            type="text"
                            placeholder="Location"
                            id="pac-input"
                            name="jobLocation"
                            value="<?php echo $traveldetails['jobLocation']; ?>"
                            required
                          />
                        
                          <input type="text" class="form-control" id="lat" value="<?php echo $traveldetails['jobLatitude']; ?>"  name="jobLatitude" data-validate="required" data-message-required="<?php echo ('value_required');?>" hidden readonly autofocus>
                          <input type="text" class="form-control" id="lng" value="<?php echo $traveldetails['jobLongitute']; ?>"  name="jobLongitute" data-validate="required" data-message-required="<?php echo ('value_required');?>" hidden  readonly>
                        </div>
                      </div>
                      <div class="row my-2 justify-content-center">
                        <div class="col-md-6">
                          <div
                            class="d-flex flex-column justify-content-center align-items-center"
                          >
                            <button class="btn my-2 LogB py-3">Add Now</button>
                          
                          </div>
                        </div>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
    </div>
       
       
        
      </div>


      <div>
      


       
      </div>

    </div>
    </div>
  </main>