<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Upload Guideline</h1>
            </div><!-- /.col -->
            <div class="col-6">
                <ol class="breadcrumb float-sm-right">
                    <button type="button" class="btn btn-sm bg-custom-blue text-white text-uppercase rounded-pill" data-toggle="modal" data-target="#guideModal">Add Guideline</button>
                </ol>
            </div>
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table id="custtbl" class="table card-table table-vcenter text-nowrap">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Type</th>
                                <th>Size</th>
                                <th>Date Uploaded</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if (!empty($guidelines)) {
                                $count = 1;
                                foreach ($guidelines as $id => $guideline) {
                            ?>
                                    <tr>
                                        <td><i class="fa-solid fa-file-lines"></i> <?php echo $guideline['name']; ?></td>
                                        <td> <?php echo $guideline['type']; ?></td>
                                        <td><?php echo $guideline['size']; ?></td>
                                        <td><?php echo date('d M Y H:i:s', $guideline['timestamp']); ?></td>
                                    </tr>

                            <?php }
                            } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->

<div class="modal hide fade" id="guideModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body d-flex flex-column justify-content-center align-items-center">
                <form action="<?= base_url('dashboard/uploadGuideline') ?>" method="post" enctype="multipart/form-data">
                    <h3> Add Guideline</h3>
                    <div class="row">
                        <div class="col-12 my-1">
                            <input type="text" class="form-control" name="name" placeholder="Guide Name">
                        </div>
                        <div class="col-12 my-1">
                            <input type="file" class="form-control" name="file" placeholder="Choose Document">
                        </div>
                    </div>
                    <button type="submit" class="btn btn-md bg-custom-blue rounded-pill mt-4">Save</button>
                </form>
            </div>
        </div>
    </div>
</div>