<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Add Staff</h1>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>

<div id="map" class="hidden"></div>
<script>
    // This example requires the Places library. Include the libraries=places
    // parameter when you first load the API. For example:
    // <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places">

    function initMap() {
        var map = new google.maps.Map(document.getElementById('map'), {
            center: {
                lat: 51.2715146,
                lng: -0.3953564
            },
            zoom: 11
        });
        var card = document.getElementById('pac-card');
        var input1 = document.getElementById('pac-input-1');
        var types = document.getElementById('type-selector');
        var strictBounds = document.getElementById('strict-bounds-selector');

        map.controls[google.maps.ControlPosition.TOP_RIGHT].push(card);

        var autocomplete1 = new google.maps.places.Autocomplete(input1);

        autocomplete1.bindTo('bounds', map);

        autocomplete1.setFields(
            ['address_components', 'geometry', 'icon', 'name']);

        var infowindow = new google.maps.InfoWindow();
        var infowindowContent = document.getElementById('infowindow-content');
        infowindow.setContent(infowindowContent);
        var marker = new google.maps.Marker({
            map: map,
            anchorPoint: new google.maps.Point(0, -29)
        });

        autocomplete1.addListener('place_changed', function() {
            infowindow.close();
            marker.setVisible(false);
            var place = autocomplete1.getPlace();


            if (!place.geometry) {
                // User entered the name of a Place that was not suggested and
                // pressed the Enter key, or the Place Details request failed.
                window.alert("No details available for input: '" + place.name + "'");
                return;
            }

            // If the place has a geometry, then present it on a map.
            if (place.geometry.viewport) {
                map.fitBounds(place.geometry.viewport);
            } else {
                map.setCenter(place.geometry.location);
                map.setZoom(17); // Why 17? Because it looks good.
            }
            marker.setPosition(place.geometry.location);
            marker.setVisible(true);

            var address = '';
            console.log(place.address_components)
            if (place.address_components) {
                var latitude = place.geometry.location.lat();
                var longitude = place.geometry.location.lng();
                console.log("addresslat:" + latitude);
                console.log("addresslng:" + longitude);
                document.getElementById("addresslat").value = latitude;
                document.getElementById("addresslng").value = longitude;

                //infodetail
                //    $("#lat").val(latitude);
                //   $("#lng").val(longitude);


                address = [
                    (place.address_components[0] && place.address_components[0].short_name || ''),
                    (place.address_components[1] && place.address_components[1].short_name || ''),
                    (place.address_components[2] && place.address_components[2].short_name || '')
                ].join(' ');
            }
            // document.getElementById("infodetail").value = place.name;
            infowindowContent.children['place-icon'].src = place.icon;
            infowindowContent.children['place-name'].textContent = place.name;
            infowindowContent.children['place-address'].textContent = address;
            infowindow.open(map, marker);
        });


        // Sets a listener on a radio button to change the filter type on Places
        // Autocomplete2.
        function setupClickListener(id, types) {
            var radioButton = document.getElementById(id);
            radioButton.addEventListener('click', function() {
                autocomplete1.setTypes(types);
            });
        }

        setupClickListener('changetype-all', []);
        setupClickListener('changetype-address', ['address']);
        setupClickListener('changetype-establishment', ['establishment']);
        setupClickListener('changetype-geocode', ['geocode']);

        document.getElementById('use-strict-bounds')
            .addEventListener('click', function() {
                console.log('Checkbox clicked! New state=' + this.checked);
                autocomplete2.setOptions({
                    strictBounds: this.checked
                });
            });
    }
</script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyC16Tbzkes6aBNrdQBsIACs-UwyHrG07k4&libraries=places&callback=initMap" async defer></script>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <form method="post" id="customer_add" class="card" enctype="multipart/form-data" action="<?php echo base_url() . "staff/insert_staff"; ?>">
            <div class="card-body d-flex flex-column justify-content-center align-items-center">
                <?php

                ?>
                <div class="row">
                    <div class="d-flex flex-row justify-content-center align-items-center mb-3">
                        <img id="uploadphoto" src="<?= base_url('assets/Slicing/addPhoto.png') ?>" style="height:200px;width:200px;" alt="">
                        <input type="file" id="image" name="image" style="display: none;" />
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" required="true" class="form-control" name="firstName" placeholder="First Name">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" required="true" class="form-control" name="lastName" placeholder="Last Name">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="email" required="true" class="form-control" name="email" placeholder="Email">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="password" required="true" class="form-control" name="password" placeholder="Password">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="date" required="true" class="form-control" name="birthDate" placeholder="Birth Date">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="date" required="true" class="form-control" name="hireDate" placeholder="Hire Date">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <select class="form-control form-select" required="true" name="category">
                                <option value="" disabled selected>Category</option>
                                <?php foreach ($users as $u => $m) {
                                    if ($m['status'] == 1) {
                                ?>
                                        <option value="<?php echo $u; ?>"><?php echo $m['name']; ?></option>
                                <?php }
                                } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <select class="form-control form-select" required="true" name="province">
                                <option value="" disabled selected>Province</option>
                                <option value="Alberta">Alberta</option>
                                <option value="British Columbia">British Columbia</option>
                                <option value="Manitoba">Manitoba</option>
                                <option value="New Brunswick">New Brunswick</option>
                                <option value="Newfoundland and Labrador">Newfoundland and Labrador</option>
                                <option value="Nova Scotia">Nova Scotia</option>
                                <option value="Ontario">Ontario</option>
                                <option value="Prince Edward Island">Prince Edward Island</option>
                                <option value="Quebec">Quebec</option>
                                <option value="Saskatchewan">Saskatchewan</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <select class="form-control form-select" name="isActive" required="true" id="">
                                <option value="" selected disabled>Status</option>
                                <option value="0">Inactive</option>
                                <option value="1">Active</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" required="true" class="form-control" name="emergencyNumber" placeholder="Emergency Contact">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" id="pac-input-1" required="true" class="form-control" name="address" placeholder="Address">
                            <input type="hidden" name="lat" id="addresslat">
                            <input type="hidden" name="lng" id="addresslng">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" required="true" class="form-control" name="ref1" placeholder="Reference 1 Full Name">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" required="true" class="form-control" name="ref2" placeholder="Reference 2 Full Name">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" required="true" class="form-control" name="ref1comment" placeholder="Reference 1 Comments">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" required="true" class="form-control" name="ref2comment" placeholder="Reference 2 Comments">
                        </div>
                    </div>
                    <!-- <div class="col-12">
                        <div class="form-group">
                            <input type="file" required="true" class="form-control" name="file" placeholder="update Document">
                        </div>
                    </div> -->

                </div>

                <button type="submit" class="btn btn-md selfalign-center rounded-pill bg-custom-blue text-white px-5"> Save</button>
            </div>
        </form>
    </div>
</section>
<!-- /.content -->

<script>
    $("#uploadphoto").click(function() {
        $("input[id='image']").click();

    });
    image.onchange = evt => {
        const [file] = image.files
        if (file) {
            uploadphoto.src = URL.createObjectURL(file)
        }
    }
</script>