<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
use Kreait\Firebase\Exception\FirebaseException;

/**
 * Class : Login (LoginController)
 * Login class to control to authenticate user credentials and starts user's session.
 * @author : Kishor Mali
 * @version : 1.1
 * @since : 15 November 2016
 */
class Signup extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('login_model');
        $this->load->helper('form');
        $this->load->helper('url');
		// $this->load->database();
		$this->load->helper('directory');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->load->model('common');
		$this->load->library('session');
        
    }


    public function index()
    {

        $this->global['pageTitle'] = 'My Aesthatic : Signup';


        $this->load->view("users/signup", $this->global, NULL);
    }

    public function register()
    {
        $this->load->library('form_validation');
    
        // Set validation rules
        $this->form_validation->set_rules('first_name', 'First Name', 'required|trim');
        $this->form_validation->set_rules('last_name', 'Last Name', 'required|trim');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[admin.email]|trim');
        $this->form_validation->set_rules('phone', 'Phone Number', 'required|trim');
        $this->form_validation->set_rules('password', 'Password', 'required|min_length[4]|trim');
        $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|matches[password]|trim');
    
        // If validation fails, reload the signup page with the errors
        if ($this->form_validation->run() == FALSE) {
            $this->index(); // Reloads the form with validation errors
        } else {
            $first_name = $this->security->xss_clean($this->input->post('first_name'));
            $last_name = $this->security->xss_clean($this->input->post('last_name'));
            $email = strtolower($this->security->xss_clean($this->input->post('email')));
            $phone = $this->security->xss_clean($this->input->post('phone'));
            $password = password_hash($this->input->post('password'), PASSWORD_BCRYPT);
    
            $full_name = $first_name . ' ' . $last_name;
            $user = 'user';

            $data = array(
                'first_name' => $first_name,
                'last_name' => $last_name,
                'name' => $full_name,  
                'email' => $email,
                'phone' => $phone,
                'role' => $user,
                'password' => $password,
            );
    
            // Load your model and insert the data
            $this->load->model('login_model');
            $insert_id = $this->login_model->registerUser($data);
    
            if ($insert_id) {

                $sessionArray = array(
                    'userId' => $insert_id,  
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                    'name' => $full_name,
                    'email' => $email,
                    'role' => 'user', 
                    'isLoggedIn' => TRUE
                );

                $this->session->set_userdata($sessionArray);

                $this->session->set_flashdata('success', 'You have successfully signed up and logged in!');

                redirect(base_url('/'));
            } else {             
                $this->session->set_flashdata('error', 'Something went wrong. Please try again.');
                redirect(base_url('signup'));
            }
        }
    }


    public function signup_action()
    {
        $this->load->library('form_validation');
    
        // ✅ Set validation rules
        $this->form_validation->set_rules('first_name', 'First Name', 'required');
        $this->form_validation->set_rules('last_name', 'Last Name', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('phone', 'Phone', 'required');
        $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');
        $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|matches[password]');
    
        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('warningmessage', validation_errors());
            $this->session->set_flashdata('form_data', $this->input->post());
            redirect(base_url('signup'));
        }
    
        try {
            // Combine first name and last name
            $name = $this->input->post('first_name') . ' ' . $this->input->post('last_name');
    
            // Initialize Firebase
            $firebase = $this->firebase->init();
            $storage = $firebase->createStorage();
            $defaultBucket = $storage->getBucket();
            $auth = $firebase->createAuth();
            $firestore = $firebase->createFirestore();
            $db = $firestore->database();
    
            // Create user in Firebase Auth
            $userProperties = [
                'email' => $this->input->post('email'),
                'password' => $this->input->post('password'),
                'displayName' => $name
            ];
    
            $createdUser = $auth->createUser($userProperties);
            $userId = $createdUser->uid;
    
            // Store user in Firestore
            $userData = [
                'name' => $name,
                'email' => $this->input->post('email'),
                'phone' => $this->input->post('phone'),
                'userType' => 'coach',
                'createdAt' => new \Google\Cloud\Core\Timestamp(new \DateTime())
            ];
    
            $db->collection('Users')->document($userId)->set($userData);
    
            // Auto login after registration
            $signInResult = $auth->signInWithEmailAndPassword(
                $this->input->post('email'),
                $this->input->post('password')
            );
    
            $my = $signInResult->data();
            $firebaseToken = $my["idToken"];
    
            $session_data = [
                'userId' => $userId,
                'name' => $userData["name"],
                'email' => $userData["email"],
                'phone' => $userData["phone"],
                'firebaseToken' => $firebaseToken,
                'userType' => $userData["userType"],
            ];
    
            $this->session->set_userdata('session_data', $session_data);
            $this->session->set_userdata('authenthicate', true);
    
            redirect(base_url('/'));
    
        } catch (\Exception $e) {
            $this->session->set_flashdata('warningmessage', 'Registration failed: ' . $e->getMessage());
            $this->session->set_flashdata('form_data', $this->input->post());
            redirect(base_url('signup'));
        }
    }
    
    
    
}
