<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Me & My Coach</title>
    <!-- bootstrap cdn -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- custom css -->


    <!-- fontawesone link -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
    <link href="<?php echo base_url(); ?>assets/css/style.css" rel="stylesheet" type="text/css" />
</head>

<style>
    #loaderWrapper {
        position: fixed;
        top: 0;
        left: 0;
        height: 100%;
        width: 100%;
        background: rgb(0 0 0 / 47%);
        z-index: 9999;
        display: flex;
        align-items: center;
        justify-content: center;
        display: none;
    }

    .loader {
        border: 6px solid #cce0ff;
        border-top: 6px solid #007bff;
        /* Blue */
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
</style>


<body class="bgPrimary">
    <!-- Loader -->
    <div id="loaderWrapper">
        <div class="loader"></div>
    </div>






    <div class="container min-h-100vh d-flex flex-column justify-content-center">
        <div class="row justify-content-center py-4">
            <div class="col-md-6">
                <img class="d-block mx-auto mb-5" src="<?php echo base_url(); ?>assets/images/logo.png" alt="" />
                <div class="my-2">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <?php
                                $successMessage = $this->session->flashdata('successmessage');
                                $warningmessage = $this->session->flashdata('warningmessage');

                                if (isset($successMessage)) {
                                                            echo '<div id="alertmessage" class="col-md-12">
                                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                            ' . output($successMessage) . '
                                        </div>
                                    </div>';
                                                        }

                                                        if (isset($warningmessage)) {
                                                            echo '<div id="alertmessage" class="col-md-12">
                                        <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                            ' . output($warningmessage) . '
                                        </div>
                                    </div>';
                                }
                                ?>
                            </div>

                            <form action="<?= base_url() . 'login/login_action'; ?>" method="post">
                                <input class="form-control my-3" type="text" name="email" id="email"
                                    placeholder="example@gmail.com" />
                                <div class="input-group my-3">
                                    <input class="form-control formInput border-r-0" type="password" name="password"
                                        id="password" placeholder="Password" />
                                    <span class="EyeIcon input-group-text bg-transparent border-l-0"><i
                                            class="eye fas fa-eye"></i></span>
                                </div>
                                <div class="my-2 text-center">
                                    <!-- Trigger link -->
                                    <a href="#" class="fs3" data-bs-toggle="modal" data-bs-target="#forgotPasswordModal">Forgot Your Password?</a>




                                </div>
                                <div class="row justify-content-center">
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btnSub py-2">
                                            Login
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <p class="fs1">
                    Don't have an account?<a href="<?php echo base_url('signup'); ?>" class="fs2">
                        Get Started</a>
                </p>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="forgotPasswordModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="<?= base_url('login/send_reset_email') ?>" method="post">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Reset Password</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>Enter your email address. We'll send you a new password. After login make sure change password.</p>
                        <input type="email" name="email" class="form-control" required placeholder="Enter your email">
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Send Link</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- custom script -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const eyeIcons = document.querySelectorAll(".eye");

            eyeIcons.forEach(function(icon) {
                icon.addEventListener("click", function() {
                    const passwordField = document.getElementById("password");
                    if (passwordField.type === "password") {
                        passwordField.type = "text";
                        this.classList.remove("fa-eye");
                        this.classList.add("fa-eye-slash");
                    } else {
                        passwordField.type = "password";
                        this.classList.remove("fa-eye-slash");
                        this.classList.add("fa-eye");
                    }
                });
            });
        });
    </script>


    <script>
        document.querySelectorAll("form").forEach(form => {
            form.addEventListener("submit", function() {
                document.getElementById("loaderWrapper").style.display = "flex";

                // form.querySelectorAll('button, input[type="submit"]').forEach(button => {
                //     button.disabled = true;
                // });
            });
        });
    </script>

</body>

</html>