<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Me & My Coach</title>
    <!-- bootstrap cdn -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- custom css -->
    <link href="<?php echo base_url(); ?>assets/css/style.css" rel="stylesheet" type="text/css" />

    <!-- fontawesone link -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
</head>



<body class="bgPrimary">
    <div class="container min-h-100vh d-flex flex-column justify-content-center">
        <div class="row justify-content-center py-4">
            <?php if ($this->session->flashdata('success')): ?>
                <script>
                    swal({
                        title: "Success!",
                        text: "<?php echo $this->session->flashdata('success'); ?>",
                        icon: "success",
                        button: "Ok"
                    });
                </script>
            <?php endif; ?>

            <?php if ($this->session->flashdata('error')): ?>
                <script>
                    swal({
                        title: "Error!",
                        text: "<?php echo $this->session->flashdata('error'); ?>",
                        icon: "error",
                        button: "Ok"
                    });
                </script>
            <?php endif; ?>
            <div class="col-md-6">
                <img class="d-block mx-auto mb-5" src="<?php echo base_url(); ?>assets/images/logo.png" alt="" />
                <div class="my-2">
                    <div class="card">
                        <div class="card-body">
                            <form action="<?php echo base_url('signup/signup_action'); ?>" method="post"
                                class="bgCardSign mx-0  border8">
                                <div class="my-2 row">
                                    <div class="col-md-6 my-2">
                                        <input class="form-control formInp py-1" type="text" name="first_name"
                                            placeholder="Enter First Name" value="<?php echo set_value('first_name'); ?>" />
                                        <?php echo form_error('first_name', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                    <div class="col-md-6 my-2">
                                        <input class="form-control formInp py-1" type="text" name="last_name"
                                            placeholder="Enter Last Name" value="<?php echo set_value('last_name'); ?>" />
                                        <?php echo form_error('last_name', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                </div>
                                <div class="my-2 row">
                                    <div class="col-md-6 my-2">
                                        <input class="form-control formInp py-1" type="email" name="email"
                                            placeholder="Enter Email" value="<?php echo set_value('email'); ?>" />
                                        <?php echo form_error('email', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                    <div class="col-md-6 my-2">
                                        <input class="form-control formInp py-1" type="text" name="phone"
                                            placeholder="Enter Phone No" value="<?php echo set_value('phone'); ?>" />
                                        <?php echo form_error('phone', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                </div>
                                <div class="my-2 row">
                                    <div class="col-md-6 my-2 position-relative">
                                        <input class="form-control formInp py-1" type="password" name="password"
                                            placeholder="Password" />
                                        <?php echo form_error('password', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                    <div class="col-md-6 my-2 position-relative">

                                        <input class="form-control formInp py-1" type="password" name="confirm_password"
                                            placeholder="Confirm Password" />
                                        <?php echo form_error('confirm_password', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                </div>
                                <div class="row my-2 justify-content-center">
                                    <div class="col-md-12">
                                        <div class="row justify-content-center">
                                            <div class="col-md-6">
                                                <div
                                                    class="d-flex flex-column justify-content-center align-items-center">
                                                    <button type="submit" class=" btn btnSub py-2">
                                                        Sign Up
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
                <p class="fs1">
                    Already have an account?<a href="<?php echo base_url('login'); ?>" class="fs2">
                        Sign In</a>
                </p>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- custom script -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const eyeIcons = document.querySelectorAll(".eye");

            eyeIcons.forEach(function(icon) {
                icon.addEventListener("click", function() {
                    const passwordField = this.previousElementSibling;
                    if (passwordField.type === "password") {
                        passwordField.type = "text";
                        this.classList.remove("fa-eye");
                        this.classList.add("fa-eye-slash");
                    } else {
                        passwordField.type = "password";
                        this.classList.remove("fa-eye-slash");
                        this.classList.add("fa-eye");
                    }
                });
            });
        });
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const eyeIcons = document.querySelectorAll(".eye");

            eyeIcons.forEach(function(icon) {
                icon.addEventListener("click", function() {
                    const passwordField = document.getElementById("password");
                    if (passwordField.type === "password") {
                        passwordField.type = "text";
                        this.classList.remove("fa-eye");
                        this.classList.add("fa-eye-slash");
                    } else {
                        passwordField.type = "password";
                        this.classList.remove("fa-eye-slash");
                        this.classList.add("fa-eye");
                    }
                });
            });
        });
    </script>
</body>

</html>