<?php
defined('BASEPATH') or exit('No direct script access allowed');

class dietplan extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		$data['podcasts'] = $this->common->readdatafromcollectionwhereclause("dietplan");
		$this->template->template_render('dietplan', $data);
	}

	public function updatediet($id)
	{
		$data = $this->input->post();
	

		$testxss = xssclean($_POST);
		if ($testxss) {
			$uniqueentity = time() * 1000;
		
			$response = $this->common->updatedatamodel("dietplan", $id, $data);
			if ($response) {

                $this->session->set_flashdata('successmessage', 'Dietplan has been updated successfully');	

			} else {
				$this->session->set_flashdata('warningmessage', validation_errors());
			}
            
			redirect('dietplan');
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('dietplan');
		}
	}

	//editpodcast
	public function editdiet($id)
	{
		$data['id'] = $id;
		$data["podcast"] = $this->common->readdatadocument("dietplan", $id);
		$this->template->template_render('diet_add', $data);
	}

	public function adddietplan()
	{
		$this->template->template_render('diet_add');
	}

	public function insertdiet()
	{
		$data = $this->input->post();
		$testxss = xssclean($_POST);
		if ($testxss) {
			$uniqueentity = time() * 1000;
			

			
			$data['id'] = $uniqueentity;
			$response = $this->common->adddatamodel("dietplan", $uniqueentity, $data);
			if ($response) {
				$this->session->set_flashdata('successmessage', 'New diet added successfully..');
			} else {
				$this->session->set_flashdata('warningmessage', validation_errors());
			}
			redirect('dietplan');
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('dietplan');
		}
	}

	public function deletediet()
	{
		$r_id = $this->uri->segment(3);
		$returndata = $this->common->deletedatamodel('dietplan', $r_id);
		if ($returndata) {
			
			$this->session->set_flashdata('successmessage', 'podcast deleted successfully..');
			redirect('dietplan');
		} else {
			$this->session->set_flashdata('warningmessage', 'Error..! Try again..');
			redirect('dietplan');
		}
	}
}