<?php
defined('BASEPATH') or exit('No direct script access allowed');

class group extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		$data['podcasts'] = $this->common->readdatafromcollectionwhereclause("group");
		$this->template->template_render('group', $data);
	}

	public function updategroup($id)
	{
		$data = $this->input->post();
	

		$testxss = xssclean($_POST);
		if ($testxss) {
			$uniqueentity = time() * 1000;
		
			$response = $this->common->updatedatamodel("group", $id, $data);
			if ($response) {

                $this->session->set_flashdata('successmessage', 'group has been updated successfully');	

			} else {
				$this->session->set_flashdata('warningmessage', validation_errors());
			}
            
			redirect('group');
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('group');
		}
	}
public function video(){
	$data['podcast']=$this->common->readdatafromcollectionwhereclause("group");
	$this->template->template_render('video_add', $data);
}
public function addvideos()
{
	$id=time();
	$data = $this->input->post();
	$group_id=$data['group_id'];

	$firebase = $this->firebase->init();
	$storage = $firebase->createStorage();
	$defaultBucket = $storage->getBucket();

	$testxss = xssclean($_POST);
	if ($testxss) {
		$uniqueentity = time() * 1000;
	

		if ($_FILES['image']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['image']['tmp_name']),
				[
					'name' => "image" . rand() . time() . $_FILES['image']['name'],
				]
			);

			$data['imageUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['video']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['video']['tmp_name']),
				[
					'name' => "video" . rand() . time() . $_FILES['video']['name'],
				]
			);

			$data['videoUrl'] = $uploadedFile->info()['mediaLink'];
		}
		$response = $this->common->adddatamodelnexted("group", $group_id,"groupdetailed",$id, $data);
		if ($response) {
		
			$this->session->set_flashdata('successmessage', 'Video has been updated successfully');
		} else {
			$this->session->set_flashdata('warningmessage', validation_errors());
		}
		redirect('group/video');
	} else {
		$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
		redirect('group/video');
	}
}


	//editpodcast
	public function editgroup($id)
	{
		$data['id'] = $id;
		$data["podcast"] = $this->common->readdatadocument("group", $id);
		$this->template->template_render('group_add', $data);
	}
public function viewgroup($id){
	$data['id'] = $id;
	$data["podcast"] = $this->common->readdatadocument("group", $id);
	$data["videolist"] = $this->common->nextedreaddatafromcollectionwhereclause("group", $id,"groupdetailed");
	$this->template->template_render('group_view', $data);
}


	public function addgroup()
	{
		$this->template->template_render('group_add');
	}

	public function insertgroup()
	{
		$data = $this->input->post();
		$data['participent']=null;
		$testxss = xssclean($_POST);
		if ($testxss) {
			$uniqueentity = time() * 1000;
			

			
			$data['id'] = $uniqueentity;
			$response = $this->common->adddatamodel("group", $uniqueentity, $data);
			if ($response) {
				$this->session->set_flashdata('successmessage', 'New group added successfully..');
			} else {
				$this->session->set_flashdata('warningmessage', validation_errors());
			}
			redirect('group');
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('group');
		}
	}

	public function deletegroup()
	{
		$r_id = $this->uri->segment(3);
		$returndata = $this->common->deletedatamodel('group', $r_id);
		if ($returndata) {
			
			$this->session->set_flashdata('successmessage', 'podcast deleted successfully..');
			redirect('group');
		} else {
			$this->session->set_flashdata('warningmessage', 'Error..! Try again..');
			redirect('group');
		}
	}
}