<!-- Begin Page Content -->
<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Logs of <?=$user['firstName']?> <?=$user['lastName']?></h2>
            </div>
        </div>
    </div>
    <?php if ($permissions != "ReadOnly") { ?>
    <div class="container-fluid">
        <div class="row pb-5">
            <div class="col-9">
                <div class="row">
                    <div class="col-12">
                        <strong>Storage Usage</strong>: <?=$user['usage']?>
                    </div>
                </div>
            </div>
            <div class="col-3">
                <div class="row">
                    <div class="col-12">
                        <a class="icon" style="text-decoration: none;" href="<?php echo base_url(); ?>customer/editcustomer/<?php echo output($uid); ?>">
                            <button class="btn btn-secondary btn-block mt-2">Reset Password</button>
                        </a>
                    </div>
                    <div class="col-12">
                        <button type="button" class="btn btn-warning btn-block mt-2" data-toggle="modal" data-target="#exampleModal" onclick="showModal('<?php echo output($uid); ?>','<?=$user['firstName']?> <?=$user['lastName']?>');">Send Warning</button>
                    </div>
                    <?php if ($user['BannerImage'] != "") { ?>

                    <div class="col-12">
                        <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($uid); ?>','<?=$user['firstName']?> <?=$user['lastName']?>', 'deleteBanner');">Remove Banner</button>
                    </div>
                    <?php } ?>
                    <?php if ($user['image'] != "") { ?>

                    <div class="col-12">
                        <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($uid); ?>','<?=$user['firstName']?> <?=$user['lastName']?>', 'deleteImage');">Remove Profile Photo</button>
                    </div>
                    <?php } ?>

                    <div class="col-12">
                        <?php if (isset($user["isBanned"]) && $user["isBanned"] == true) {
                                            ?>
                        <button class="btn btn-success btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($uid); ?>','<?=$user['firstName']?> <?=$user['lastName']?>', 'unBanCustomer');">Unban User</button>
                        <?php
                                            } else {
                                            ?>
                        <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($uid); ?>','<?=$user['firstName']?> <?=$user['lastName']?>', 'banCustomer');">Ban User</button>
                        <?php
                                            } ?>
                    </div>
                    <div class="col-12">
                        <?php if ($user["isActive"] === false) {
                                            ?>
                        <button class="btn btn-success btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($uid); ?>','<?=$user['firstName']?> <?=$user['lastName']?>', 'unSuspendCustomer');">Activate User</button>
                        <?php
                                            } else {
                                            ?>
                        <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($uid); ?>','<?=$user['firstName']?> <?=$user['lastName']?>', 'suspendCustomer');">Deactivate User</button>
                        <?php
                                            } ?>
                    </div>
                    <div class="col-12">
                        <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($uid); ?>','<?=$user['firstName']?> <?=$user['lastName']?>', 'deleteCustomer');">Delete User
                            Account</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <!-- <h6 class="m-0 font-weight-bold text-primary">DataTables Example</h6> -->
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="songTable" width="100%" cellspacing="0">
                    <thead class="thead-dark">
                        <tr>
                            <th>Log Type</th>
                            <th>Log Date</th>
                            <th>Log Details</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (!empty($logs)) {
                            $count = 1;
                            foreach ($logs as $id => $log) {
                        ?>
                        <tr>
                            <td> <?php echo $log['type']; ?></td>
                            <td> <?php echo date('Y-m-d h:i:s A',$log['extradata']['notificationTime']/1000); ?></td>
                            <td><?php echo $log['content']; ?></td>
                        </tr>
                        <?php }
                        } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Songs of <?=$user['firstName']?> <?=$user['lastName']?></h2>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <!-- <h6 class="m-0 font-weight-bold text-primary">DataTables Example</h6> -->
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="songTable3" width="100%" cellspacing="0">
                    <thead class="thead-dark">
                        <tr>
                            <th>Song Title</th>
                            <th>Created Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (!empty($songs)) {
                            $count = 1;
                            foreach ($songs as $id => $song) {
                        ?>
                        <tr>
                            <td> <?php echo $song['SongTitle']; ?></td>
                            <td> <?php echo date('Y-m-d h:i:s A',$song['createdDate']/1000); ?></td>
                        </tr>
                        <?php
                    $count++;    
                    }
                        } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Recordings of <?=$user['firstName']?> <?=$user['lastName']?></h2>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <!-- <h6 class="m-0 font-weight-bold text-primary">DataTables Example</h6> -->
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="songTable4" width="100%" cellspacing="0">
                    <thead class="thead-dark">
                        <tr>
                            <th>Recording</th>
                            <th>Created Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (!empty($recordings)) {
                            $count = 1;
                            foreach ($recordings as $id => $recording) {
                        ?>
                        <tr>
                            <td>
                                <audio controls>
                                    <source src="<?php echo $recording['url']; ?>" type="audio/x-m4a">
                                    Your browser does not support the audio element.
                                </audio>

                            </td>
                            <td> <?php echo date('Y-m-d h:i:s A',$recording['date']/1000); ?></td>
                        </tr>
                        <?php
                    $count++;    
                    }
                        } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Warnings to <?=$user['firstName']?> <?=$user['lastName']?></h2>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <!-- <h6 class="m-0 font-weight-bold text-primary">DataTables Example</h6> -->
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="songTable5" width="100%" cellspacing="0">
                    <thead class="thead-dark">
                        <tr>
                            <th>Date</th>
                            <th>Warning</th>
                            <!-- <th>Action</th> -->
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (!empty($logs)) {
                            $count = 1;
                            foreach ($logs as $id => $log) {
                                if($log['type'] == 'Admin Warning' || $log['type'] == 'adminWarnings') {
                        ?>
                        <tr>
                            <td> <?php echo date('Y-m-d h:i:s A',$log['extradata']['notificationTime']/1000); ?></td>
                            <td><?php echo $log['content']; ?></td>
                            <!-- <td> <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($id); ?>','deleteLog');">Delete Log</button> -->
                            </td>
                        </tr>
                        <?php $count++; }  }
                        } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <form method="post" action="<?=base_url('customer/sendWarning')?>">
        <input id="user-id" type="hidden" name="userid" value="" />
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Send Warning to "<spna id="user-name"></spna>"
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form>

                        <div class="form-group">
                            <label for="message-text" class="col-form-label">Warning Message:</label>
                            <textarea class="form-control" id="message-text" rows="5" name="message" required></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Send Warning</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="exampleModa2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <form method="get" name="cform" action="">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel2"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="submitBtn"></button>
                </div>
            </div>
        </div>
    </form>
</div>
<!-- /.container-fluid -->
<script>
function showModal(userid, username) {
    document.getElementById('user-name').innerText = username;
    document.getElementById('user-id').value = userid;
}

function showConfirmation(userid, username, action) {
    let url = "";
    let message = "";
    let btnTitle = "";
    switch (action) {
        case 'deleteBanner':
            url = "<?php echo base_url(); ?>customer/deleteBanner/" + userid;
            message = "Are you sure you want to remove banner of user '" + username + "'?";
            btnTitle = "Remove Banner";
            break;
        case 'deleteImage':
            url = "<?php echo base_url(); ?>customer/deleteImage/" + userid;
            message = "Are you sure you want to remove profile phot of user '" + username + "'?";
            btnTitle = "Remove Profile Photo";
            break;
        case 'banCustomer':
            url = "<?php echo base_url(); ?>customer/banCustomer/" + userid;
            message = "Are you sure you want to ban user '" + username + "'?";
            btnTitle = "Ban User";
            break;
        case 'unBanCustomer':
            url = "<?php echo base_url(); ?>customer/unBanCustomer/" + userid;
            message = "Are you sure you want to Unbanned user '" + username + "'?";
            btnTitle = "Unban User";
            break;
        case 'suspendCustomer':
            url = "<?php echo base_url(); ?>customer/suspendCustomer/" + userid;
            message = "Are you sure you want to deactivate user '" + username + "'?";
            btnTitle = "Deactivate User";
            break;
        case 'unSuspendCustomer':
            url = "<?php echo base_url(); ?>customer/unSuspendCustomer/" + userid;
            message = "Are you sure you want to activate user '" + username + "'?";
            btnTitle = "Activate User";
            break;
        case 'deleteCustomer':
            url = "<?php echo base_url(); ?>customer/deleteCustomer/" + userid;
            message = "Are you sure you want to delete user '" + username + "'?";
            btnTitle = "Delete User";
            break;
        default:
            return false;
    }

    document.getElementById('exampleModalLabel2').innerText = message;
    document.getElementById('submitBtn').innerText = btnTitle;
    document.cform.action = url;
}
</script>