<?php
defined('BASEPATH') or exit('No direct script access allowed');

class instrumentalist extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		$data['podcasts'] = $this->common->readdatafromcollectionwhereclause("Instrumentalist");
		$this->template->template_render('podcast_management', $data);
	}

	public function updatepodcast($id)
	{
		$data = $this->input->post();
		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();

		$testxss = xssclean($_POST);
		if ($testxss) {
			$uniqueentity = time() * 1000;
		

			if ($_FILES['image']['tmp_name'] != '') {
				$uploadedFile = $defaultBucket->upload(
					file_get_contents($_FILES['image']['tmp_name']),
					[
						'name' => "podcast" . rand() . time() . $_FILES['image']['name'],
					]
				);

				$data['imageUrl'] = $uploadedFile->info()['mediaLink'];
			}
			$response = $this->common->updatedatamodel("Instrumentalist", $id, $data);
			if ($response) {
				$permissions = $this->session->userdata('session_data')['permissions'];
				if(!empty($permissions)) {
					$podcast = $this->common->readdatadocument("Instrumentalist", $id);
					$adminName = $this->session->userdata('session_data')['name'];
					$adminEmail = $this->session->userdata('session_data')['email'];

					$auditData = [
						'adminName' => $adminName,
						'adminEmail' => $adminEmail,
						'time' => time(),
						'action' => "Instrument Updated",
						'details' => $adminName." Updated instrument ".$podcast['name'],
					];

					AddAuditLog($auditData);	
				}
				$this->session->set_flashdata('successmessage', 'podcast has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', validation_errors());
			}
			redirect('Instrumentalist');
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('Instrumentalist');
		}
	}

	//editpodcast
	public function editpodcast($id)
	{
		$data['id'] = $id;
		$data["podcast"] = $this->common->readdatadocument("Instrumentalist", $id);
		$this->template->template_render('podcast_add', $data);
	}

	public function addpodcast()
	{
		$this->template->template_render('podcast_add');
	}

	public function insertpodcast()
	{
		$data = $this->input->post();
		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();

		$testxss = xssclean($_POST);



		if ($testxss) {
			$uniqueentity = time() * 1000;
			
			if ($_FILES['image']['tmp_name'] != '') {
				$uploadedFile = $defaultBucket->upload(
					file_get_contents($_FILES['image']['tmp_name']),
					[
						'name' => "podcast" . rand() . time() . $_FILES['image']['name'],
					]
				);

				$data['imageUrl'] = $uploadedFile->info()['mediaLink'];
			}
			
			$data['id'] = $uniqueentity;
			$response = $this->common->adddatamodel("Instrumentalist", $uniqueentity, $data);
			if ($response) {
				$this->session->set_flashdata('successmessage', 'New podcast added successfully..');
			} else {
				$this->session->set_flashdata('warningmessage', validation_errors());
			}
			redirect('Instrumentalist');
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('Instrumentalist');
		}
	}
	// public function insertpodcast()
	// {
	// 	$data = $this->input->post();
	// 	$firebase = $this->firebase->init();
	// 	$storage = $firebase->createStorage();
	// 	$defaultBucket = $storage->getBucket();

	// 	$testxss = xssclean($_POST);
	// 	if ($testxss) {
	// 		$uniqueentity = time() * 1000;
	// if ($_FILES['media']['tmp_name'] != '') {
	// 	$uploadedFile = $defaultBucket->upload(
	// 		file_get_contents($_FILES['media']['tmp_name']),
	// 		[
	// 			'name' => "podcast" . rand() . time() . $_FILES['media']['name'],
	// 		]
	// 	);
	// 	$data['media'] = $uploadedFile->info()['mediaLink'];
	// }

	// 		if ($_FILES['image']['tmp_name'] != '') {
	// 			$uploadedFile = $defaultBucket->upload(
	// 				file_get_contents($_FILES['image']['tmp_name']),
	// 				[
	// 					'name' => "podcast" . rand() . time() . $_FILES['image']['name'],
	// 				]
	// 			);

	// 			$data['imageUrl'] = $uploadedFile->info()['mediaLink'];
	// 		}
	// 		$data['id'] = $uniqueentity;
	// 		$response = $this->common->adddatamodel("Podcasts", $uniqueentity, $data);
	// 		if ($response) {
	// 			$this->session->set_flashdata('successmessage', 'New podcast added successfully..');
	// 		} else {
	// 			$this->session->set_flashdata('warningmessage', validation_errors());
	// 		}
	// 		redirect('podcast');
	// 	} else {
	// 		$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
	// 		redirect('podcast');
	// 	}
	// }
	public function deletepodcast()
	{
		$r_id = $this->uri->segment(3);
		$returndata = $this->common->deletedatamodel('Instrumentalist', $r_id);
		if ($returndata) {
			$permissions = $this->session->userdata('session_data')['permissions'];
			if(!empty($permissions)) {
				$podcast = $this->common->readdatadocument("Instrumentalist", $r_id);
				$adminName = $this->session->userdata('session_data')['name'];
				$adminEmail = $this->session->userdata('session_data')['email'];

				$auditData = [
					'adminName' => $adminName,
					'adminEmail' => $adminEmail,
					'time' => time(),
					'action' => "Instrument Deleted",
					'details' => $adminName." Deleted instrument ".$podcast['name'],
				];

				AddAuditLog($auditData);	
			}
			$this->session->set_flashdata('successmessage', 'podcast deleted successfully..');
			redirect('Instrumentalist');
		} else {
			$this->session->set_flashdata('warningmessage', 'Error..! Try again..');
			redirect('Instrumentalist');
		}
	}
}