<?php
defined('BASEPATH') or exit('No direct script access allowed');

use Kreait\Firebase\Exception\FirebaseException;
//use Throwable;

class Login extends CI_Controller
{
	//To load initial libraries, functions
	function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('directory');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->load->model('common');
		$this->load->library('session');
	}


	public function index()
	{

		if (!empty($this->session->userdata('session_data'))) {
			$url = base_url('dashboard');
			header("location: $url");
		} else {
			$this->load->view('login');
		}
	}

	// public function login_action()
	// {

	// 	echo 	$email = $this->input->post("email");
	// 	echo 	$password = $this->input->post("password");


	// 	$firebase = $this->firebase->init();

	// 	$auth = $firebase->createAuth();


	// 	try {
	// 		$signInResult = $auth->signInWithEmailAndPassword($email, $password);

	// 	} catch (FirebaseException $e) {
	// 		$this->session->set_flashdata('warningmessage', 'Invalid email and/or password !');
	// 		$this->session->set_flashdata('email', $email);
	// 		redirect(base_url('login'));
	// 	}

	// 	$my = $signInResult->data();
	// 	$admin=$this->common->readdatadocument("Users",$my['localId']);		


	// 	if (!empty($my["idToken"])) {

	// 		$session_data = array(
	// 			'userId' => $my["localId"],
	// 			'name' => $admin["name"],
	// 			'email' => $admin["email"],
	// 			'u_image' => $admin["u_image"],
	// 			'firebaseToken' => $my["idToken"],
	// 			'userType'=>$admin["userType"],
	// 		);
	// 		$this->session->set_userdata('session_data', $session_data);
	// 		$this->session->set_userdata('authenthicate', true);
	// 		// print_r($admin["u_image"]);
	// 		// die;
	// 		echo '<pre>';
	// 		print_r($this->session->userdata('session_data'));
	// 		echo '</pre>';
	// 		die;
	// 		redirect(base_url('dashboard'));
	// 	} else {
	// 		$this->session->set_flashdata('warningmessage', 'Invalid email and/or password1 !');
	// 		$this->session->set_flashdata('email', $email);
	// 		redirect(base_url('login'));
	// 	}
	// }

	public function login_action()
	{
		$email = $this->input->post("email");
		$password = $this->input->post("password");

		$firebase = $this->firebase->init();
		$auth = $firebase->createAuth();

		try {
			// Attempt to sign in with email and password
			$signInResult = $auth->signInWithEmailAndPassword($email, $password);
		} catch (FirebaseException $e) {
			// Authentication failed
			$this->session->set_flashdata('warningmessage', 'Invalid email and/or password!');
			$this->session->set_flashdata('email', $email);
			redirect(base_url('login'));
		}

		$my = $signInResult->data();
		$userId = $my['localId'];

		// Fetch user data from Firestore
		$admin = $this->common->readdatadocument("Users", $userId);

		if (isset($admin["userType"]) && $admin["userType"] !== 'owner') {
			// Check user type is not admin
			$this->session->set_flashdata('warningmessage', 'You are not authorized to log in!');
			redirect(base_url('login'));
		}

		if (!empty($my["idToken"])) {
			// Prepare session data
			$session_data = array(
				'userId' => $userId,
				'name' => $admin["name"],
				'email' => $admin["email"],
				'u_image' => $admin["u_image"],
				'firebaseToken' => $my["idToken"],
				'userType' => $admin["userType"],
			);
			// echo '<pre>';
			// print_r($session_data);
			// echo '<pre>';
			// die;
			$this->session->set_userdata('session_data', $session_data);
			$this->session->set_userdata('authenthicate', true);

			redirect(base_url('dashboard'));
		} else {
			// Fallback in case of unexpected issues
			$this->session->set_flashdata('warningmessage', 'Something went wrong! Please try again.');
			$this->session->set_flashdata('email', $email);
			redirect(base_url('login'));
		}
	}


	//To logout session from browser
	public function logout()
	{
		// Removing session data
		$sess_array = array('userId' => '');
		$this->session->unset_userdata('session_data', $sess_array);
		$this->session->sess_destroy();
		$this->session->set_flashdata('successmessage', 'Successfully Logged out !');
		redirect(base_url('login'));
	}
}
