<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
		$this->load->model('customer_model');
  }
  
  public function settings()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");
    
    
    $this->template->template_render('settings', $data);
  }

  

  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Settings has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }



  public function index()
  {
    $data['pageTitle'] = "Dashboard";
    
    $data['totalUsers'] = $this->common->readnumberofdocumentsincollection('Users');
   
    // $data['users'] = $this->common->readdatafromcollectionwhereclause("Users");
    // $data['users']=count($users);
    //   foreach ($users as $key => $user) {
    //     $timestamps[$key]    = $user['userDate'];
    // }
    // array_multisort($timestamps, SORT_ASC, $users);
    // $labels = array();

    // $labels[0] = date('F', strtotime(date('F')." - 3 months"));
    // for($i =1; $i<=5; $i++) {
    //   $timestamp = strtotime($labels[$i-1].' + 1 month');
    //   $labels[$i] = date('F', $timestamp);
    // }
    // $labelStr = '';
    // foreach($labels as $label) {
    //   $labelStr .= '"'.$label.'", ';
    // }
    
    // $data['labelStr'] = $labelStr;
    // $dataStr = '';
    // for($i =0; $i<count($labels); $i++) {
    //   $num = 0;
    //   foreach($timestamps as $timestamp) {
    //     if($labels[$i] == date('F', $timestamp/1000)) {
    //       $num += 0.2;
    //     }
    //   }
    //   $dataStr .= $num.',';
    // }
    // $data['dataStr'] = $dataStr;

   
    $this->template->template_render('index', $data);
  }

  public function users()
	{
    $data['pageTitle'] = "Users";
		$data['customerlist'] = $this->customer_model->getall_customer();
		
		$this->template->template_render('users', $data);
	}

  public function cities()
	{

    $data['pageTitle'] = "Cities";
		
    $data['cities'] = $this->common->readdatafromcollectionwhereclause("Cities");
		
		$this->template->template_render('cities', $data);
	}

  public function deleteCity($id)
	{
		
		$response = $this->common->deletedatamodel("Cities", $id);

    if($response) {
      
      $this->session->set_flashdata('successmessage', 'City Deleted');
    }else{
			$this->session->set_flashdata('warningmessage', 'System Error: Please again later');
    }
		
			redirect(base_url().'dashboard/cities');
	}

  public function places()
	{

    $data['pageTitle'] = "Places";
		
    $data['places'] = $this->common->readdatafromcollectionwhereclause("Places");
		
		$this->template->template_render('places', $data);
	}

  public function deletePlace($id)
	{
		
		$response = $this->common->deletedatamodel("Places", $id);

    if($response) {
      
      $this->session->set_flashdata('successmessage', 'Place Deleted');
    }else{
			$this->session->set_flashdata('warningmessage', 'System Error: Please again later');
    }
		
			redirect(base_url().'dashboard/places');
	}

  public function events()
	{

    $data['pageTitle'] = "Events";
		
    $data['events'] = $this->common->readdatafromcollectionwhereclause("Events");
		
		$this->template->template_render('events', $data);
	}

  public function deleteEvent($id)
	{
		
		$response = $this->common->deletedatamodel("Events", $id);

    if($response) {
      
      $this->session->set_flashdata('successmessage', 'Event Deleted');
    }else{
			$this->session->set_flashdata('warningmessage', 'System Error: Please again later');
    }
		
			redirect(base_url().'dashboard/events');
	}

  public function eventplaces()
	{

    $data['pageTitle'] = "Events";
		
    $data['eventplaces'] = $this->common->readdatafromcollectionwhereclause("EventPlaces");
		
		$this->template->template_render('eventplaces', $data);
	}

  public function deleteEventPlace($id)
	{
		
		$response = $this->common->deletedatamodel("EventPlaces", $id);

    if($response) {
      
      $this->session->set_flashdata('successmessage', 'Event Place Deleted');
    }else{
			$this->session->set_flashdata('warningmessage', 'System Error: Please again later');
    }
		
			redirect(base_url().'dashboard/eventplaces');
	}

}