<section id="minimal-statistics" class="minimal-statistics">
    <div class="container-fluid">
        <div class="row gy-3">
            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12">
                <a href="<?= base_url('dashboard/users'); ?>">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <div class="media d-flex">
                                    <div class="icon-dashboardPoint">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="45" viewBox="0 0 50 45">
                                            <path id="Icon_metro-users" data-name="Icon metro-users"
                                                d="M35.9,39.008V36.688c3.06-1.746,5.556-6.1,5.556-10.452,0-6.99,0-12.656-8.333-12.656s-8.333,5.666-8.333,12.656c0,4.353,2.5,8.706,5.556,10.452v2.319c-9.423.78-16.667,5.468-16.667,11.135H52.571a8.05,8.05,0,0,0-2.487-5.508c-2.643-2.875-7.933-5.11-14.18-5.627ZM16.773,40.094a26.207,26.207,0,0,1,8.671-3.534,15.875,15.875,0,0,1-1.757-2.594,16.262,16.262,0,0,1-2.018-7.73c0-3.781,0-7.352,1.328-10.273a9.059,9.059,0,0,1,6.911-5.251c-.734-3.361-2.688-5.57-7.892-5.57-8.333,0-8.333,5.666-8.333,12.656,0,4.353,2.5,8.706,5.556,10.452V30.57c-9.423.78-16.667,5.468-16.667,11.135h12.11a17.816,17.816,0,0,1,2.092-1.612Z"
                                                transform="translate(-2.571 -5.143)" fill="#ff9800" />
                                        </svg>
                                    </div>
                                    <div class="media-body content-total text-right">
                                        <h3 class="number-total"><?=$totalUsers?></h3>
                                        <span class="total-referral">Users</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12">
                <a href="<?= base_url('dashboard/users'); ?>">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <div class="media d-flex">
                                    <div class="icon-dashboardPoint">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="50" height="45" viewBox="0 0 50 45">
                                            <defs>
                                                <pattern id="pattern" preserveAspectRatio="none" width="100%" height="100%" viewBox="0 0 300 266">
                                                    <image width="300" height="266"
                                                        xlink:href="data:image/png;base64,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" />
                                                </pattern>
                                            </defs>
                                            <rect id="Image_21" data-name="Image 21" width="50" height="45" fill="url(#pattern)" />
                                        </svg>

                                    </div>
                                    <div class="media-body content-total text-right">
                                        <h3 class="number-total">60</h3>
                                        <span class="total-referral">Tour Purchased</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12">
                <a href="<?= base_url('dashboard/purchasedWithMoney'); ?>">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <div class="media d-flex">
                                    <div class="icon-dashboardPoint">
                                        <img src="<?= base_url('/assets/images/Image22.png') ?>" alt="icon">
                                    </div>
                                    <div class="media-body content-total text-right">
                                        <h3 class="number-total">47</h3>
                                        <span class="total-referral">Purchased with money</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12">
                <a href="<?= base_url('dashboard/purchasedWithVoucher'); ?>">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <div class="media d-flex">
                                    <div class="icon-dashboardPoint">
                                        <img src="<?= base_url('/assets/images/Image23.png') ?>" alt="icon">
                                    </div>
                                    <div class="media-body content-total text-right">
                                        <h3 class="number-total">13</h3>
                                        <span class="total-referral">Purchased with Voucher</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12">
                <a href="<?= base_url('dashboard/peopleCheckin'); ?>">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <div class="media d-flex">
                                    <div class="icon-dashboardPoint">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="31" height="45" viewBox="0 0 31 45">
                                            <image id="Image_24" data-name="Image 24" width="31" height="45"
                                                xlink:href="data:image/png;base64,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" />
                                        </svg>

                                    </div>
                                    <div class="media-body content-total text-right">
                                        <h3 class="number-total">605</h3>
                                        <span class="total-referral">People Check in</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12">
                <a href="<?= base_url('dashboard/postToInstagram'); ?>">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <div class="media d-flex">
                                    <div class="icon-dashboardPoint">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="45" height="45" viewBox="0 0 45 45">
                                            <image id="Image_25" data-name="Image 25" width="45" height="45"
                                                xlink:href="data:image/png;base64,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" />
                                        </svg>


                                    </div>
                                    <div class="media-body content-total text-right">
                                        <h3 class="number-total">6K</h3>
                                        <span class="total-referral">Post to Instagram</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

        </div>

        <div class="row gy-3 mt-4 mb-5">
            <div class="col-12">
                <div class="bg-color-chart">
                    <div class="chart-title-div">
                        <h4 class="chart-title">User Signup Trending</h4>
                    </div>
                    <div class="padding-chart">
                        <canvas id="myChart" style="width:100%;max-width:100%"></canvas>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>

<!-- index end -->

<?php
//  include("./assets/links/bottomlinks.php");
?>
<script>
var xValues = ["January", "February", "March", "April", "May", "June"];
var yValues = [];
generateData(0, 5);

new Chart("myChart", {
    type: "line",
    data: {
        labels: xValues,
        datasets: [{
            fill: true, // Fill the area under the curve
            backgroundColor: "rgba(98, 149, 209, 0.5)", // Background color
            borderColor: "rgba(0,0,255,0.5)",
            borderWidth: 1,
            pointRadius: 2,
            data: yValues
        }]
    },
    options: {
        legend: {
            display: false
        },
        title: {
            display: false,
        },
        scales: {
            y: {
                beginAtZero: true,
                min: 0,
                max: 5,
                ticks: {
                    stepSize: 0.5
                }
            }
        }
    }
});

function generateData(minValue, maxValue) {
    for (let i = 0; i < xValues.length; i++) {
        // Generate y-values in the specified pattern
        if (xValues[i] === "January") {
            yValues.push(0);
        } else if (xValues[i] === "February") {
            yValues.push(0);
        } else if (xValues[i] === "March") {
            yValues.push(5.0);
        } else if (xValues[i] === "April") {
            yValues.push(3.0);
        } else if (xValues[i] === "May") {
            yValues.push(0);
        } else if (xValues[i] === "June") {
            yValues.push(0);
        } else {
            yValues.push(minValue);
        }
    }
}
</script>