document.addEventListener("DOMContentLoaded", function () {
	const reportButton = document.getElementById("reportButton");
	const reportPopup = document.getElementById("reportPopup");
	const closeReportPopup = document.getElementById("closeReportPopup");
  
	// Function to show the popup
	function showPopup() {
	  reportPopup.style.display = "block";
	}
  
	// Function to hide the popup
	function hidePopup() {
	  reportPopup.style.display = "none";
	}
  
	// Event listener for the "Reports" button
	reportButton.addEventListener("click", function () {
	  showPopup();
	});
  
	// Event listener for the close button inside the popup
	closeReportPopup.addEventListener("click", function () {
	  hidePopup();
	});
  
	// Close the popup if the user clicks outside of it
	window.addEventListener("click", function (event) {
	  if (event.target === reportPopup) {
		hidePopup();
	  }
	});
  });
  

  document.addEventListener("DOMContentLoaded", function () {
	const feedbackButton = document.getElementById("feedbackButton");
	const feedbackPopup = document.getElementById("feedbackPopup");
	const closeFeedbackPopup = document.getElementById("closeFeedbackPopup");
	const feedbackMessagesContainer = document.getElementById("feedbackMessages");
  
	// Function to show the feedback popup
	function showFeedbackPopup() {
	  feedbackPopup.style.display = "block";
	}
  
	// Function to hide the feedback popup
	function hideFeedbackPopup() {
	  feedbackPopup.style.display = "none";
	}
  
	// Function to add admin's feedback messages to the popup
	function showAdminFeedbackMessages(messages) {
	  feedbackMessagesContainer.innerHTML = ""; // Clear previous messages
	  messages.forEach((message) => {
		const messageElement = document.createElement("p");
		messageElement.textContent = message;
		feedbackMessagesContainer.appendChild(messageElement);
	  });
	}
  
	// Event listener for the "Feedback" button
	feedbackButton.addEventListener("click", function () {
	  // In this example, I'm assuming you have an array of feedback messages from the admin
	  const adminFeedbackMessages = [
		"Thank you for your valuable feedback!",
		"We appreciate your suggestions.",
		"Your feedback helps us improve our services.",
	  ];
	  showAdminFeedbackMessages(adminFeedbackMessages);
	  showFeedbackPopup();
	});
  
	// Event listener for the close icon
	closeFeedbackPopup.addEventListener("click", function () {
	  hideFeedbackPopup();
	});
  
	// Close the feedback popup if the user clicks outside of it
	window.addEventListener("click", function (event) {
	  if (event.target === feedbackPopup) {
		hideFeedbackPopup();
	  }
	});
  });
  