const filterButtons = document.querySelectorAll(".filter-btns");
const filterableButtons = document.querySelectorAll(".patient-card-column");

filterButtons.forEach(function (button) {
	button.addEventListener("click", function () {
		// Remove "active" class from all buttons
		filterButtons.forEach(function (btn) {
			btn.classList.remove("active");
		});
		// Add "active" class to the clicked button
		this.classList.add("active");

		const filterValue = this.getAttribute("data-filter");

		// Show all buttons if filterValue is "all"
		if (filterValue === "all") {
			filterableButtons.forEach(function (button) {
				button.classList.remove("hide");
			});
		} else {
			// Hide buttons that do not match the filterValue
			filterableButtons.forEach(function (button) {
				const category = button.getAttribute("data-category");
				if (category !== filterValue) {
					button.classList.add("hide");
				} else {
					button.classList.remove("hide");
				}
			});
		}
	});
});

// var notification = document.getElementById("notification");
// var notificationContainer = document.getElementById("notificationContainer");
// notification.addEventListener("click", () => {
// 	notificationContainer.classList.toggle("show");
// });

// document.addEventListener("click", (event) => {
//   var targetElement = event.target;
  
//   // Check if the click occurred outside the notification container
//   if (!notificationContainer.contains(targetElement) && targetElement !== notification) {
//     notificationContainer.classList.remove("show");
//   }
// });

