<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
    $this->load->model('customer_model');
  }
  public function particpentuser()
  {

    $myuserpurchaselist = array();
    $purchasecity = $this->common->readdatafromcollectionwhereclause("Users", "userPurchasedCity", "!=", []);

    foreach ($purchasecity as $key => $value) {

      foreach ($value['userPurchasedCity'] as $key1 => $value1) {
        //echo $key1."<br>";
        array_push($myuserpurchaselist, $key1);
      }
    }



    $events = $this->common->readdatafromcollectionwhereclause("Cities");


    $shella = array();

    foreach ($events as $key => $value) {
      // echo $key;

      $value['noofcount'] = $this->arraycount($myuserpurchaselist, $key);
      $shella[$key] = $value;

      //array_push($shella, $jana);
      # code...
    }
    $jana['pageTitle'] = " Participants User";
    $jana['cities'] = $shella;

    $this->template->template_render('particpentuser', $jana);
  }
  function arraycount($array, $value)
  {
    $counter = 0;
    foreach ($array as $thisvalue) /*go through every value in the array*/ {
      if ($thisvalue === $value) { /*if this one value of the array is equal to the value we are checking*/
        $counter++; /*increase the count by 1*/
      }
    }
    return $counter;
  }

  public function settings()
  {
    // $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");
    $this->session->set_flashdata('warningmessage', 'Settings has been updated');


    $this->template->template_render('index');
  }



  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if ($response) {
      $this->session->set_flashdata('successmessage', 'Settings has been updated');
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }
  //updateprofile
  public function updateprofile()
  {
    $id = $this->session->userdata('session_data')['userId'];
    $da = $this->input->post();
    //print_r($da);
    $data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
    $this->session->set_flashdata('successmessage', 'Profile has been updated successfully');

    redirect(base_url() . 'dashboard/profilesetting');
  }

  public function profilesetting()
  {
    $data['pageTitle'] = "Profile";
    $c_id = $this->session->userdata('session_data')['userId'];
    $data['customerdetails'] = $this->customer_model->get_customerdetails($c_id);
    $data['customerdetails']['id'] = $c_id;
    $this->template->template_render('profilesetting', $data);
  }


  public function peopleCheckin()
  {

    $data['places'] = $this->common->readdatafromcollectionwhereclause("Places", "userReached", "!=", []);
    // echo "<pre>";
    // print_r($data);

    // echo "</prE>";
    // exit;

    $data['pageTitle'] = "People Check in";

    $this->template->template_render('peoplecheckin', $data);
  }


  public function index()
  {




    $timestamps = array();
    $purchasingtimestamps = array();
    $posttimestamps = array();
    $data['pageTitle'] = "Dashboard";


    $Requests = $this->common->readdatafromcollectionwhereclause("Requests");
    $accepted = 0;
    $rejected = 0;
    $pending = 0;



    $users = $this->common->readdatafromcollectionwhereclause("Users");
    $booking = $this->common->readdatafromcollectionwhereclause("Bookings");
    $data['booking'] = count($booking);




    foreach ($users as $key => $user) {
      if ($user['userRole'] == "admin") {
      } else {
        $timestamps[$key]    = $user['userDate'];
      }
      if ($user['userRole'] == "user") {
        $accepted++;
      }
      if ($user['userRole'] == "provider") {
        $rejected++;
      }
    }
    $data['accepted'] = $accepted;
    $data['rejected'] = $rejected;
    $data['pending'] = $pending;
    // echo "<prE>";
    // print_r($data);
    // echo "</pre>";
    // exit;

    array_multisort($timestamps, SORT_ASC, $users);
    $labels = array();
    //echo  date('F');

    //echo $labels[0] =date('F');
    $labels[0] =  date('F', strtotime($labels[0] . " + 7 month"));

    for ($i = 1; $i <= 5; $i++) {
      $timestamp = strtotime($labels[$i - 1] . ' + 1 month');
      $labels[$i] = date('F', $timestamp);
    }
    $labelStr = '';
    foreach ($labels as $label) {
      $labelStr .= '"' . $label . '", ';
    }

    $data['labelStr'] = $labelStr;
    //    echo "<pre>";
    // print_r($data['labelStr']);
    // echo "</pre>";
    // exit;
    $dataStr = '';
    for ($i = 0; $i < count($labels); $i++) {
      $num = 0;
      foreach ($timestamps as $timestamp) {
        // echo date('F', $timestamp/1000);
        // echo date('Y',$timestamp/1000);
        // echo date('Y');

        if ($labels[$i] == date('F', $timestamp / 1000) && date('Y', $timestamp / 1000) == date('Y')) {
          $num += 1;
        }
      }
      $dataStr .= $num . ',';
    }
    $data['dataStr'] = $dataStr;
    $timestamps = array();


    foreach ($inst as $key => $user) {
      $timestamps[$key]    = $user['timestamp'];
    }
    array_multisort($timestamps, SORT_ASC, $inst);
    $labels = array();
    //echo  date('F');

    //echo $labels[0] =date('F');
    $labels[0] =  date('F', strtotime($labels[0] . " + 7 month"));

    for ($i = 1; $i <= 5; $i++) {
      $timestamp = strtotime($labels[$i - 1] . ' + 1 month');
      $labels[$i] = date('F', $timestamp);
    }
    $labelStr = '';
    foreach ($labels as $label) {
      $labelStr .= '"' . $label . '", ';
    }

    $data['labelStr'] = $labelStr;

    $data['totalUsers'] = count($users) - 1;


    // print_r($data);
    // die;


    $this->template->template_render('index', $data);
  }

  public function users()
  {
    if ($this->session->userdata('session_data')['permissions'] == "subadmin") {
      redirect(base_url() . 'dashboard/cities');
    }
    $data['pageTitle'] = "Users";
    $data['customerlist'] = $this->customer_model->getall_customer();

    $this->template->template_render('users', $data);
  }

  public function purchase($param1 = "all")
  {

    $data['type'] = $param1;
    $data['pageTitle'] = "Purchase";
    $data['customerlist'] = $this->common->readdatafromcollectionwhereclause("Transactions");
    $this->template->template_render('purchase', $data);
  }

  public function cities()
  {

    $data['pageTitle'] = "Tours";

    $data['cities'] = $this->common->readdatafromcollectionwhereclause("Cities");

    $this->template->template_render('cities', $data);
  }

  public function addcity()
  {

    $data['pageTitle'] = "Add New Tour";


    $this->template->template_render('addcity', $data);
  }

  public function addcitydone()
  {
    $this->session->set_flashdata('successmessage', 'New Tour Added');
    redirect(base_url() . 'dashboard/cities');
  }

  public function editcity($id)
  {
    if (!$id) die('Direct access not allowed');

    $data['pageTitle'] = "Update Tour";
    $data['id'] = $id;


    $this->template->template_render('editcity', $data);
  }


  public function deleteCity($id)
  {
    $places = $this->common->readdatafromcollectionwhereclause("Places", 'cityId', '=', $id);

    foreach ($places as $key => $place) {
      $this->common->deletedatamodel("Places", $key);
    }


    $users = $this->common->readdatafromcollectionwhereclause("Users");
    foreach ($users as $key => $user) {
      $userPurchasedCities = $user['userPurchasedCity'];

      $tmp = array_filter($userPurchasedCities, function ($key) {
        return $key != $id;
      }, ARRAY_FILTER_USE_KEY);
      $data['userPurchasedCity'] = $tmp;
      $this->common->updatedatamodel("Users", $key, $data);
    }

    // die;

    $response = $this->common->deletedatamodel("Cities", $id);

    if ($response) {

      $this->session->set_flashdata('successmessage', 'Tour Deleted');
    } else {
      $this->session->set_flashdata('warningmessage', 'System Error: Please again later');
    }

    redirect(base_url() . 'dashboard/cities');
  }

  public function places()
  {

    $data['pageTitle'] = "Tour Places";

    $data['places'] = $this->common->readdatafromcollectionwhereclause("Places");

    $this->template->template_render('places', $data);
  }


  //discount
  public function discount()
  {

    //  $data['pageTitle'] = "Donations";
    $data['pageTitle'] = "Orders";

    $data['places'] = $this->common->readdatafromcollectionwhereclause("Bookings");

    // print_r($data);
    // die;
    $this->template->template_render('discount', $data);
  }

  public function deletePlace($id)
  {
    $response = $this->common->deletedatamodel("Places", $id);

    if ($response) {

      $this->session->set_flashdata('successmessage', 'Tour Place Deleted');
    } else {
      $this->session->set_flashdata('warningmessage', 'System Error: Please again later');
    }

    redirect(base_url() . 'dashboard/places');
  }
  public function deletediscount($id)
  {
    $response = $this->common->deletedatamodel("Discount", $id);

    if ($response) {

      $this->session->set_flashdata('successmessage', 'Discount Deleted');
    } else {
      $this->session->set_flashdata('warningmessage', 'System Error: Please again later');
    }

    redirect(base_url() . 'dashboard/discount');
  }

  public function addplace()
  {

    $data['pageTitle'] = "Add New Tour Place";


    $this->template->template_render('addplace', $data);
  }

  public function  adddiscount()
  {
    $data['pageTitle'] = "Add Discount";


    $this->template->template_render('adddiscount', $data);
  }

  public function editplace($id)
  {
    if (!$id) die('Direct access not allowed');

    $data['pageTitle'] = "Update Tour Place";
    $data['id'] = $id;


    $this->template->template_render('editplace', $data);
  }

  public function addplacedone()
  {
    $this->session->set_flashdata('successmessage', 'New Tour Place Added');
    redirect(base_url() . 'dashboard/places');
  }

  public function events()
  {

    $data['pageTitle'] = "Parties";

    $data['events'] = $this->common->readdatafromcollectionwhereclause("Events");

    $this->template->template_render('events', $data);
  }

  public function addevent()
  {

    $data['pageTitle'] = "Add New Party";


    $this->template->template_render('addevent', $data);
  }

  public function editevent($id)
  {
    if (!$id) die('Direct access not allowed');

    $data['pageTitle'] = "Update Party";
    $data['id'] = $id;


    $this->template->template_render('editevent', $data);
  }

  public function addeventdone()
  {
    $this->session->set_flashdata('successmessage', 'New Party Added');
    redirect(base_url() . 'dashboard/events');
  }

  public function deleteEvent($id)
  {

    $response = $this->common->deletedatamodel("Events", $id);

    if ($response) {

      $this->session->set_flashdata('successmessage', 'Party Deleted');
    } else {
      $this->session->set_flashdata('warningmessage', 'System Error: Please again later');
    }

    redirect(base_url() . 'dashboard/events');
  }

  public function eventplaces()
  {

    $data['pageTitle'] = "Party Places";

    $data['eventplaces'] = $this->common->readdatafromcollectionwhereclause("EventPlaces");

    $this->template->template_render('eventplaces', $data);
  }

  public function addeventplace()
  {

    $data['pageTitle'] = "Add New Party Place";


    $this->template->template_render('addeventplace', $data);
  }

  //editdiscount
  public function viewbooking($id)
  {
    if (!$id) die('Direct access not allowed');

    $data['pageTitle'] = "Order Summery";
    $data['id'] = $id;
    $data['customerdetails'] = $this->common->readdatadocument("Bookings", $id);

    // print_r($data);
    // die;
    $this->template->template_render('editdiscount', $data);
  }
  public function editeventplace($id)
  {
    if (!$id) die('Direct access not allowed');

    $data['pageTitle'] = "Update Party Place";
    $data['id'] = $id;


    $this->template->template_render('editeventplace', $data);
  }

  public function addeventplacedone()
  {
    $this->session->set_flashdata('successmessage', 'New Party Place Added');
    redirect(base_url() . 'dashboard/eventplaces');
  }

  public function deleteEventPlace($id)
  {

    $response = $this->common->deletedatamodel("EventPlaces", $id);

    if ($response) {

      $this->session->set_flashdata('successmessage', 'Party Place Deleted');
    } else {
      $this->session->set_flashdata('warningmessage', 'System Error: Please again later');
    }

    redirect(base_url() . 'dashboard/eventplaces');
  }

  public function instagram()
  {

    $data['pageTitle'] = "Instagram Posts";

    $data['instagrams'] = $this->common->readdatafromcollectionwhereclause("InstagramPost");

    $this->template->template_render('instagram', $data);
  }

  public function deleteInstagram($id)
  {

    $response = $this->common->deletedatamodel("InstagramPost", $id);

    if ($response) {

      $this->session->set_flashdata('successmessage', 'Instagram Post Place Deleted');
    } else {
      $this->session->set_flashdata('warningmessage', 'System Error: Please again later');
    }

    redirect(base_url() . 'dashboard/instagram');
  }
}
