<section id="minimal-statistics" class="minimal-statistics">
    <div class="container-fluid">
        <div class="row gy-3 my-3 w-100">
            <div class="table-responsive">
                <table id="myTable" class="table table-bordered table-striped">
                    <thead class="thead">
                        <tr>
                            <th>Service Image</th>
                            <th>Customer</th>
                            <th>Date/Time</th>
                            <th>Address</th>
                            <th>Category</th>
                            <th>Subcategory</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="tbody">
                        <?php if (!empty($places)) : ?>
                            <?php foreach ($places as $id => $data) :

                                // Date/Time
                                $dateTime = isset($data['dateTime']) ? convertTime($data['dateTime']) : (isset($data['createdAt']) ? convertTime($data['createdAt']) : 'N/A');

                                // Customer Name
                                $customerName = $data['userName'] ?? getusername($data['userId']);

                                // Address
                                $address = $data['address'] ?? 'N/A';

                                // Category / Subcategory
                                $category = $data['category'] ?? 'N/A';
                                $subCategory = $data['serviceType'] ?? ($data['subCategory'] ?? 'N/A');

                                // Price
                                $totalPrice = $data['price'] ?? 0;

                                // Service Image
                                $serviceImage = $data['serviceImage'] ?? '';

                                // Status
                                $statusText = strtolower($data['status'] ?? '');
                                switch ($statusText) {
                                    case 'await':
                                    case 'awaited':
                                        $status = '<span class="badge bg-info">Await</span>';
                                        break;
                                    case 'accept':
                                    case 'accepted':
                                        $status = '<span class="badge bg-success">Accepted</span>';
                                        break;
                                    case 'complete':
                                    case 'completed':
                                        $status = '<span class="badge bg-success">Completed</span>';
                                        break;
                                    case 'review':
                                    case 'reviewed':
                                        $status = '<span class="badge bg-warning">Reviewed</span>';
                                        break;
                                    case 'rejected':
                                        $status = '<span class="badge bg-danger">Rejected</span>';
                                        break;
                                    default:
                                        $status = '<span class="badge bg-secondary">' . output($data['status'] ?? 'N/A') . '</span>';
                                }
                            ?>
                                <tr>
                                    <td>
                                        <?php if (!empty($serviceImage)) : ?>
                                            <img src="<?= output($serviceImage) ?>" class="img-thumbnail" style="max-width:100px; max-height:100px;">
                                        <?php else : ?>
                                            N/A
                                        <?php endif; ?>
                                    </td>
                                    <td><?= output($customerName); ?></td>
                                    <td><?= output($dateTime); ?></td>
                                    <td><?= output($address); ?></td>
                                    <td><?= output($category); ?></td>
                                    <td><?= output($subCategory); ?></td>
                                    <td><?= output($totalPrice . "$"); ?></td>
                                    <td><?= $status; ?></td>
                                    <td>
                                        <a class="icon" style="text-decoration: none;" href="<?= base_url('dashboard/viewbooking/') . $id ?>">
                                            <button class="btn btn-warning mt-2">View</button>
                                        </a>
                                        <a class="icon" style="text-decoration: none;">
                                            <button class="btn btn-danger mt-2" onclick="showConfirmation('<?= $id ?>')">Delete</button>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>

<script>
    function showConfirmation(id) {
        Swal.fire({
            title: 'Are you sure you want to delete this?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = '<?= base_url(); ?>dashboard/deletediscount/' + id;
            }
        });
    }
</script>