<section id="minimal-statistics" class="minimal-statistics">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-6 mx-auto mt-5">
        <div class="myform form">
          <div class="table-responsive">
            <table class="table table-sm table-bordered table-hover">
              <tbody>

                <!-- Service Image -->
                <tr>
                  <th>Service Image</th>
                  <td>
                    <?php if (!empty($customerdetails['serviceImage'])): ?>
                      <img src="<?= output($customerdetails['serviceImage']) ?>" class="img-thumbnail" style="max-width:100px; max-height:100px;">
                    <?php else: ?>
                      N/A
                    <?php endif; ?>
                  </td>
                </tr>

                <!-- Customer Name -->
                <tr>
                  <th>Customer</th>
                  <td><?= output($customerdetails['userName'] ?? 'N/A') ?></td>
                </tr>

                <!-- Date -->
                <tr>
                  <th>Date/Time</th>
                  <td><?= convertTimeinMonth($customerdetails['bookingDate'] ?? $customerdetails['createdAt']) ?></td>
                </tr>

                <!-- Contractor (Service Provider Name) -->
                <tr>
                  <th>Contractor</th>
                  <td><?= output($customerdetails['providerName'] ?? 'N/A') ?></td>
                </tr>

                <!-- Category -->
                <tr>
                  <th>Category</th>
                  <td><?= is_array($customerdetails['category']) ? implode(", ", $customerdetails['category']) : ($customerdetails['category'] ?? 'N/A') ?></td>
                </tr>

                <!-- Subcategory / Service Type -->
                <tr>
                  <th>Subcategory</th>
                  <td><?= is_array($customerdetails['subCategory']) ? implode(", ", $customerdetails['subCategory']) : ($customerdetails['serviceType'] ?? 'N/A') ?></td>
                </tr>

                <!-- Address -->
                <tr>
                  <th>Address</th>
                  <td><?= output($customerdetails['address'] ?? 'N/A') ?></td>
                </tr>

                <!-- Latitude -->
                <tr>
                  <th>Latitude</th>
                  <td><?= output($customerdetails['lat'] ?? 'N/A') ?></td>
                </tr>

                <!-- Longitude -->
                <tr>
                  <th>Longitude</th>
                  <td><?= output($customerdetails['lng'] ?? 'N/A') ?></td>
                </tr>

                <!-- Total Price -->
                <tr>
                  <th>Total Price</th>
                  <td><?= output(($customerdetails['price'] ?? 0) . "$") ?></td>
                </tr>

                <!-- Status -->
                <tr>
                  <th>Status</th>
                  <td>
                    <?php
                    $status = strtolower($customerdetails['status'] ?? '');
                    $badges = [
                      'await' => 'info',
                      'awaited' => 'info',
                      'accept' => 'success',
                      'accepted' => 'success',
                      'complete' => 'success',
                      'completed' => 'success',
                      'review' => 'warning',
                      'reviewed' => 'warning',
                      'rejected' => 'danger'
                    ];
                    echo '<span class="badge bg-' . ($badges[$status] ?? 'secondary') . '">' . ucfirst($status ?: 'N/A') . '</span>';
                    ?>
                  </td>
                </tr>

              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>