<section id="minimal-statistics" class="minimal-statistics">
    <div class="container-fluid">
        <div class="row gy-3 my-3 w-100">
            <div class="table-responsive">
                <?php
                // echo "<pre>";
                // print_r($customerlist);
                // echo "</pre>";
                ?>
                <table id="myTable" class="display">
                    <thead class="thead">
                        <tr>
                            <th>#</th>
                            <th>User Name</th>
                            <th>Image</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Joining Date</th>
                            <th>Address</th>
                            <!--
                        <th>Category</th>
                            <th>Subcategory</th>
                            
                            <th>Heading</th>
                            <th>Price per Hr</th> 
                            <th>About Me</th>  
-->
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody class="tbody">
                        <?php
                        if (!empty($customerlist)) {
                            $count = 1;
                            foreach ($customerlist as $id => $customerlists) {

                                // Handle Name
                                $userName = !empty($customerlists['fullName']) ? $customerlists['fullName'] : 'N/A';

                                // Handle Image
                                $img = !empty($customerlists['userImage']) ? $customerlists['userImage'] : (!empty($customerlists['image']) ? $customerlists['image'] : '');

                                // Handle Address
                                $address = !empty($customerlists['selectedAddress']['address']) ?
                                    $customerlists['selectedAddress']['address'] : (!empty($customerlists['address']) ? $customerlists['address'] : 'N/A');

                                // Handle Joining Date (milliseconds to seconds)
                                $joiningDate = isset($customerlists['userDate']) ? date('d M, Y', $customerlists['userDate'] / 1000) : 'N/A';
                        ?>
                                <tr>
                                    <td><?= $count++; ?></td>
                                    <td><?= output($userName); ?></td>
                                    <td>
                                        <?php if ($img != '') { ?>
                                            <a href="<?= $img ?>" target="_blank">
                                                <img class="img-thumbnail" width="100" height="100" src="<?= output($img); ?>">
                                            </a>
                                        <?php } else { ?>
                                            <img class="img-thumbnail" src="http://placehold.jp/100x100.png">
                                        <?php } ?>
                                    </td>
                                    <td><?= output($customerlists['email'] ?? 'N/A'); ?></td>
                                    <td><?= output($customerlists['phoneNumber'] ?? 'N/A'); ?></td>
                                    <td><?= $joiningDate; ?></td>
                                    <td><?= output($address); ?></td>
                                    <td>
                                        <!-- Agreement Button -->
                                        <!-- <?php if (isset($customerlists['approveAgreement']) && $customerlists['approveAgreement'] == false) { ?>
                                            <a class="icon" disabled style="text-decoration: none;" href="<?= base_url(); ?>customer/acceptaggrement/<?= output($id); ?>">
                                                <button disabled class="btn btn-info mt-2" style="color:black">Agreement Approve?</button>
                                            </a>
                                        <?php } else { ?>
                                            <a class="icon" disabled style="text-decoration: none;" href="#">
                                                <button disabled class="btn btn-success mt-2" style="color:black">Agreement Approved</button>
                                            </a>
                                        <?php } ?> -->

                                        <!-- View Button -->
                                        <a class="icon" disabled style="text-decoration: none;" href="<?= base_url(); ?>customer/viewserviceprovider/<?= output($id); ?>">
                                            <button disabled class="btn btn-info mt-2" style="color:black">View</button>
                                        </a>

                                        <!-- Active/Suspend Button -->
                                        <?php if (!empty($customerlists['isActive']) && $customerlists['isActive'] == true) { ?>
                                            <a class="icon" disabled style="text-decoration: none;" href="<?= base_url(); ?>customer/approve/<?= output($id); ?>">
                                                <button disabled class="btn btn-success mt-2" style="color:black">Make Active</button>
                                            </a>
                                        <?php } else { ?>
                                            <a class="icon" disabled style="text-decoration: none;" href="<?= base_url(); ?>customer/suspend/<?= output($id); ?>">
                                                <button disabled class="btn btn-warning mt-2" style="color:black">Suspend Account</button>
                                            </a>
                                        <?php } ?>

                                        <!-- Delete Button -->
                                        <a class="icon" disabled style="text-decoration: none;" href="<?= base_url(); ?>customer/remove/<?= output($id); ?>">
                                            <button disabled class="btn btn-danger mt-2">Delete Account</button>
                                        </a>
                                        <?php if (empty($customerlists['isAdminVerified'])) { ?>
                                            <a class="icon" style="text-decoration: none;" href="<?= base_url(); ?>customer/approveprovider/<?= output($id); ?>">
                                                <button class="btn btn-primary mt-2">Approve Provider</button>
                                            </a>
                                        <?php } else { ?>
                                            <button class="btn btn-success mt-2" disabled>Approved</button>
                                        <?php } ?>

                                    </td>
                                </tr>
                        <?php
                            }
                        }
                        ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</section>
<script>
    function showConfirmation(id) {
        Swal.fire({
            title: 'Are you sure you want to delete this user?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = '<?php echo base_url(); ?>customer/remove/' + id;
            }
        });
    }
</script>