function showPopup1() {
	const popup = document.getElementById("popup");
	popup.style.display = "block";
	setTimeout(function () {
		popup.style.display = "none";
	}, 5000);
}
document.addEventListener("DOMContentLoaded", function () {
	const editProfileForm = document.getElementById("editProfile-form");

	editProfileForm.addEventListener("submit", function (event) {
		event.preventDefault();
		showPopup1(); 
		if (validateForm()) {
			// If the form is valid, you can submit it here
			editProfileForm.submit();
		}
	});

	function validateForm() {
		const firstName = document.getElementById("firstName").value.trim();
		const lastName = document.getElementById("lastName").value.trim();
		const organization = document.getElementById("organization").value.trim();
		const email = document.getElementById("email").value.trim();
		const phone = document.getElementById("phone").value.trim();
		const addressOne = document.getElementById("addressOne").value.trim();
		const addressTwo = document.getElementById("addressTwo").value.trim();

		// Validate each field based on your requirements
		if (firstName === "") {
			alert("First Name cannot be empty");
			return false;
		}

		if (lastName === "") {
			alert("Last Name cannot be empty");
			return false;
		}

		if (organization === "") {
			alert("Organization cannot be empty");
			return false;
		}

		// Validate email format using a regular expression
		const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
		if (!emailRegex.test(email)) {
			alert("Invalid email format");
			return false;
		}

		// Validate phone number using a regular expression
		const phoneRegex = /^[+]\d{2}-\d{3}-\d{6,}$/;
		if (!phoneRegex.test(phone)) {
			alert("Invalid phone number format. Example: +01-234-567890");
			return false;
		}

		if (addressOne === "") {
			alert("Address 1 cannot be empty");
			return false;
		}

		if (addressTwo === "") {
			alert("Address 2 cannot be empty");
			return false;
		}
		// All validations passed, the form is valid
		return true;1
	}
});

// Add event listener to the close button to hide the popup
const closeButton = document.querySelector(".close-button");
closeButton.addEventListener("click", function () {
	const popup = document.getElementById("popup");
	popup.style.display = "none";
});
