document
    .getElementById("sidebar-toggle")
    .addEventListener("click", function() {
        document
            .getElementsByClassName("adjust-width")[0]
            .classList.toggle("sidebar-open");
    });

	document
    .getElementById("x-mark")
    .addEventListener("click", function() {
        document
            .getElementsByClassName("adjust-width")[0]
            .classList.remove("sidebar-open");
    });

const dropdown = document.getElementById("dropdown");
const dropDownTopBar = document.getElementById("drop-down-top-bar");
// Trigger the change event when an option is clicked
const options = document.querySelectorAll("#dropdown option");
options.forEach(function(option) {
    option.addEventListener("click", function() {
        dropdown.value = option.value; // Manually set the dropdown value to the clicked option
        dropdown.dispatchEvent(new Event("change")); // Trigger the change event
    });
});

dropDownTopBar.addEventListener("click", function(event) {
    dropdown.classList.toggle("active");
    dropdown.size = 2;
    // if (event.target === dropDownTopBar) {
    // 	dropdown.classList.toggle("active");
    // 	dropdown.size = 2;
    // }
});

// Function to close the dropdown when clicked outside
function closeDropdownOnClickOutside(event) {
    if (!dropDownTopBar.contains(event.target)) {
        dropdown.size = 1;
        dropdown.classList.remove("active");
    }
}

// Add a click event listener on the document to close the dropdown on clicks outside
document.addEventListener("click", closeDropdownOnClickOutside);

dropdown.addEventListener("change", function() {
    const selectedOption = dropdown.value;
    if (selectedOption === "logout") {
        const logoutOption = document.querySelector(
            '#dropdown option[value="logout"]'
        );
        const url = logoutOption.dataset.url;
        window.location.href = url;
    } else {
        // Handle other options as needed
        const editOption = document.querySelector('#dropdown option[value="edit"]');
        const url = editOption.dataset.url;
        window.location.href = url;
    }
    dropdown.size = 2; // Set the size attribute back to 1 when the dropdown loses focus
    dropdown.classList.remove("active");
});


// Add more sliders and timers as needed

function navLinksContent() {
    const navLinks = document.querySelectorAll(".links-menu");
    const btnsCase = document.querySelectorAll(".btns-case");
    const headerContent = document.getElementById("header-content");
    const contentDashboard = document.getElementById("content-dashboard");
    const contentHistory = document.getElementById("content-history");
    const contentReports = document.getElementById("content-reports");
    const contentFeedback = document.getElementById("content-feedback");
    const contentMessages = document.getElementById("content-messages");

    navLinks.forEach(function(link) {
        // Check if the current URL matches the link's href
        link.classList.remove("active");
        if (window.location.href === link.href) {
            link.classList.add("active");
        }

        link.addEventListener("click", function(event) {
            event.preventDefault();
            const clickedLink = this;
            const content = clickedLink.getAttribute("data-content");

            // Remove "active" class from all links
            navLinks.forEach(function(link) {
                link.classList.remove("active");
            });

            // Add "active" class to the clicked link
            clickedLink.classList.add("active");

            // Show/hide content based on the clicked link
            if (content === "dashboard") {
                // contentDashboard.style.display = "block";
                // contentHistory.style.display = "none";
                headerContent.textContent = "Dashboard";
            } else if (content === "history") {
                // contentDashboard.style.display = "none";
                // contentHistory.style.display = "block";
                headerContent.textContent = "History";
            } else if (content === "messages") {
                // contentDashboard.style.display = "none";
                // contentHistory.style.display = "block";
                headerContent.textContent = "Chat with Admin";
            }

            // Navigate to the clicked link's URL
            window.location.href = clickedLink.href;
        });

        if (
            window.location.href.includes("history") ||
            window.location.href.includes("cases")
        ) {
            const historyLink = document.querySelector('a[data-content="history"]');
            if (historyLink) {
                historyLink.classList.add("active");
            }
            headerContent.textContent = "History";
            // clickedLink.classList.add("active");
        } else if(window.location.href.includes("messages")){
			const messagesLink = document.querySelector('a[data-content="messages"]');
            if (messagesLink) {
                messagesLink.classList.add("active");
            }
            headerContent.textContent = "Chat with Admin";
		} else {
            headerContent.textContent = "Dashboard";
            // clickedLink.classList.add("active");
        }
    });
    
    btnsCase.forEach(function(btn) {
        // Check if the current URL matches the link's href
        btn.classList.remove("active");
        if (window.location.href === btn.href) {
            btn.classList.add("active");
        }

        btn.addEventListener("click", function(event) {
            event.preventDefault();
            const clickedLink = this;
            const content = clickedLink.getAttribute("data-content");

            // Remove "active" class from all links
            btnsCase.forEach(function(btn) {
                btn.classList.remove("active");
            });

            // Add "active" class to the clicked link
            clickedLink.classList.add("active");

            // Show/hide content based on the clicked link
            if (content === "view reports") {
                // contentDashboard.style.display = "block";
                // contentHistory.style.display = "none";
                headerContent.textContent = "Reports";
            } else if (content === "view feedback") {
                // contentDashboard.style.display = "none";
                // contentHistory.style.display = "block";
                headerContent.textContent = "Feedback";
            }

            // Navigate to the clicked link's URL
            window.location.href = clickedLink.href;
        });

        if (
            window.location.href.includes("reports/1")
        ) {
            const reportsLink = document.querySelector('a[data-content="view reports"]');
            if (reportsLink) {
                reportsLink.classList.add("active");
            }
            headerContent.textContent = "Reports";
            // clickedLink.classList.add("active");
        } else if (
            window.location.href.includes("feedback/1")
        ) {
            const feedbackLink = document.querySelector('a[data-content="view feedback"]');
            if (feedbackLink) {
                feedbackLink.classList.add("active");
            }
            headerContent.textContent = "Feedback";
            // clickedLink.classList.add("active");
        }
    });
}

window.addEventListener("DOMContentLoaded", function() {
    navLinksContent();
});
