// Function to show the popup
function showPopup() {
	const popup = document.getElementById("popup");
	popup.style.display = "block";
	setTimeout(function () {
		popup.style.display = "none";
	}, 5000);
}

// Function to validate the form
function validateForm() {
	var firstName = document.getElementById("firstName").value;
	var lastName = document.getElementById("lastName").value;
	var organization = document.getElementById("organization").value;
	var totalPatient = document.getElementById("totalPatient").value;
	var addressOne = document.getElementById("addressOne").value;
	var addressTwo = document.getElementById("addressTwo").value;
	var city = document.getElementById("city").value;
	var state = document.getElementById("state").value;
	var zip = document.getElementById("zip").value;

	// Simple validation (you can add more specific validation rules if needed)
	if (
		firstName === "" ||
		lastName === "" ||
		organization === "" ||
		totalPatient === "" ||
		addressOne === "" ||
		city === "" ||
		state === "" ||
		zip === ""
	) {
		alert("Please fill in all required fields.");
		return false;
	}

	// Validate totalPatient as a positive number
	if (isNaN(totalPatient) || parseInt(totalPatient) <= 0) {
		alert("Please enter a valid number of patient referrals.");
		return false;
	}

	// Optionally, you can add more specific validation rules for other fields
	showPopup();
	// If all validations pass, the form will be submitted
	return true;
}

// Attach the form validation function to the form's submit event
var form = document.getElementById("postRequest-form");
// form.onsubmit = function () {
// 	return validateForm();
// };

// Add event listener to the close button to hide the popup
const closeButton = document.querySelector(".close-button");
closeButton.addEventListener("click", function () {
	const popup = document.getElementById("popup");
	popup.style.display = "none";
});

// checkboxes

const customCheckboxes = document.querySelectorAll(".custom-checkbox input");

customCheckboxes.forEach((checkbox) => {
	checkbox.addEventListener("change", function () {
		if (this.checked) {
			this.parentElement.classList.add("checked");
		} else {
			this.parentElement.classList.remove("checked");
		}
	});
});
