<section class="h-100 new-bg gradient-custom">
    <div class="container py-5">
        <div class="row d-flex justify-content-center my-4">
            <div class="col-md-8">
                <div class="card mb-4">
                    <div class="card-header card-bg py-3">
                        <h5 class="productDetails-title mb-0">Cart - <?=count($cartItems)?> items</h5>
                    </div>
                    <form id="frmUpdateCart" method="post" action="<?=base_url('site/updatecart')?>">
                        <div class="card-body">
                            <?php
							$shippingCost = 0;
							$totalPrice = 0;
							$count = count($cartItems);
							foreach($cartItems as $key => $item) {

								$itemPrice = (int)$item['price'] * (int)$item['quantity'];
								$totalPrice = $totalPrice + $itemPrice;
                                $shippingCost = 10;
							
						?>
                            <div class="row">
                                <div class="col-lg-3 col-md-12 mb-4 mb-lg-0">
                                    <div class="bg-image t-shirt-div hover-overlay hover-zoom ripple rounded" data-mdb-ripple-color="light">
                                        <img class="w-100 tshirt-image" src="<?=$item['url']?>" alt="Blue Jeans Jacket" />
                                    </div>
                                </div>

                                <div class="col-lg-5 col-md-6 mb-4 mb-lg-0">
                                    <h4 class="profile-title line-height"><?=$item['name']?></h4>
                                    <!-- <p class="color-details">Color: <span> White </span></p> -->
                                    <!-- <p class="color-details">Size: <span> M </span> </p> -->
                                    <a href="<?=base_url()?>site/removefromcart/<?=$key?>">
                                        <button type="button" class="btn btn-primary btn-sm me-1 mb-2" data-mdb-toggle="tooltip" title="Remove from cart">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </a>
                                    <!-- <button type="button" class="btn btn-danger btn-sm mb-2" data-mdb-toggle="tooltip" title="Move to the wish list">
                                    <i class="fas fa-heart"></i>
                                </button> -->
                                </div>

                                <div class="col-lg-4 col-md-6 mb-4 mb-lg-0">

                                    <div class="input-group productDetail-div mb-3 mx-width">
                                        <span class="input-group-text productDetail-text left" onclick="this.parentNode.querySelector('input[type=number]').stepDown()">-</span>
                                        <input type="number" min="1" name="quantity[<?=$key?>]" step="1" class="form-control productDetail-text" value="<?=$item['quantity']?>" oninput="this.value = Math.abs(this.value)">
                                        <span class="input-group-text productDetail-text right" onclick="this.parentNode.querySelector('input[type=number]').stepUp()">+</span>
                                    </div>

                                    <p class="price-product text-start text-md-center">
                                        $<?=$item['price']?> X <?=$item['quantity']?> = $<?=$itemPrice?>
                                    </p>
                                </div>
                            </div>
                            <?php if($count > 1) {?>
                            <hr class="my-4" />
                            <?php }?>
                            <?php $count--; } ?>
                        </div>
                    </form>
                </div>
                <div class="d-flex justify-content-end mt-5">
                    <!-- <button class="custom-button-download-app continue-shopping me-4">Continue shopping</button> -->
                    <!-- <button type="button" class="btn btn-primary btn-lg">Add to cart</button> -->
                    <button type="button" class="read-more-btn productDetailsBuyBtn max-width-adjust mt-0" onclick="updateCart();">
                        Update Cart
                    </button>
                    <span>&nbsp;&nbsp;&nbsp;</span>
                    <button type="button" class="read-more-btn productDetailsBuyBtn max-width-adjust mt-0" onclick="clearCart();">
                        Clear Cart
                    </button>
                </div>

                <!-- <div class="card mb-4">
                    <div class="card-body">
                        <h4 class="profile-title my-3">Expected shipping delivery</h4>
                        <p class="color-details mb-3">12.10.2020 - 14.10.2020</p>
                    </div>
                </div>

                <div class="card mb-4 mb-lg-0">
                    <div class="card-body">
                        <h4 class="profile-title my-3">We accept</h4>
                        <img class="me-2" width="45px" src="https://mdbcdn.b-cdn.net/wp-content/plugins/woocommerce-gateway-stripe/assets/images/visa.svg" alt="Visa" />
                        <img class="me-2" width="45px" src="https://mdbcdn.b-cdn.net/wp-content/plugins/woocommerce-gateway-stripe/assets/images/amex.svg" alt="American Express" />
                        <img class="me-2" width="45px" src="https://mdbcdn.b-cdn.net/wp-content/plugins/woocommerce-gateway-stripe/assets/images/mastercard.svg" alt="Mastercard" />
                        <img class="me-2" width="45px" src="https://mdbcdn.b-cdn.net/wp-content/plugins/woocommerce/includes/gateways/paypal/assets/images/paypal.webp" alt="PayPal acceptance mark" />
                    </div>
                </div> -->
            </div>
            <div class="col-md-4">
                <div class="card mb-4">
                    <div class="card-header card-bg py-3">
                        <h5 class="productDetails-title mb-0">Summary</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item product-details-price d-flex justify-content-between align-items-center border-0">
                                Total Price
                                <span class="product-details-price">$<?=$totalPrice?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Shipping
                                <span>$<?=$shippingCost?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center border-0 px-0 mb-3">
                                <div>
                                    <h4 class="profile-title">Grand Total</h4>
                                    <!-- <strong>
                                        <p class="profile-title m-0">(including VAT)</p>
                                    </strong> -->
                                </div>
                                <span class="profile-title">$<?=$totalPrice+$shippingCost?></span>
                            </li>
                        </ul>

                        <div class="d-flex align-items-end px-0 pb-0 mt-auto">
                            <button type="button" class="read-more-btn productDetailsBuyBtn max-width-adjust" onclick="checkout();">
                                Checkout
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
//frmUpdateCart
function checkout() {
    window.location.href = '<?=base_url()?>site/checkout';
}

function clearCart() {
    window.location.href = '<?=base_url()?>site/clearcart';
}

function updateCart() {
    $('#frmUpdateCart').submit();
}
</script>