<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>YAHLOVE</title>
    <link rel="icon" type="image/x-icon" href="<?= base_url('assets/img/Logo-1.png') ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <!-- Bootstrap CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&family=Poppins:wght@400;500;600;700&family=Rubik:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.5.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="<?= base_url() . "assets/css/style.css" ?>">
</head>

<body>
    <div class="main-content-yahlove position-relative">
        <section class="section-navbar">
            <nav class="navbar navbar-expand-lg navbar-dark custom-navbar">
                <div class="container">
                    <div class="navbar-img-div">
                        <a class="navbar-brand" href="<?= base_url() ?>">
                            <img src="<?= base_url() . "assets/img/Logoyahlove.png" ?>" class="logo-navbar-img" alt="Logo">
                        </a>
                    </div>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                        <ul class="navbar-nav">
                            <li class="nav-item">
                                <a class="nav-link" href="<?= base_url() ?>">Home</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= base_url('site/products') ?>">MarketPlace</a>
                            </li>
                            <!-- <li class="nav-item">
                                <a class="nav-link" href="<?= base_url() ?>#features">Features</a>
                            </li> -->
                            <!-- <li class="nav-item">
                                <a class="nav-link" href="<?= base_url() ?>#screenshot">Screenshort</a>
                            </li> -->
                            <!-- <li class="nav-item">
                                <a class="nav-link" href="<?= base_url() ?>#contact">Contact</a>
                            </li> -->
                        </ul>
                        <div class="button-download-app btns-flex">
                            <a href="<?= base_url('site/cart') ?>">
                                <button class="custom-button-download-app">My Cart</button>
                            </a>
                            <?php
                            if(!isset($this->session->userdata('session_data')['userId'])){
                            ?>
                            <a href="<?= base_url('site/login') ?>">
                                <button class="custom-button-download-app">Login</button>
                            </a>

                            <a href="<?= base_url('site/signup') ?>">
                                <button class="custom-button-download-app">Sign Up</button>
                            </a>
                            <?php
                                }
                            ?>
                        </div>
                        <?php
                            if(isset($this->session->userdata('session_data')['userId'])){
                        ?>
                        <div class="nav-item dropdown btn btn-lg btn-job-seeker user-content p-0 display-none-media">
                            <div class="img-profile">
                                <img src="<?= base_url('/assets/img/user15238988491689944580download.jpg') ?>" class="profile-img-user" alt="User">
                            </div>
                            <a class="nav-link atag-header p-0 dropdown-toggle">
                                <span class="name-user"><?=substr($this->session->userdata('session_data')['name'], 0, 8)?></span>
                            </a>
                            <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                <li><a class="dropdown-item" href="">Change Password</a></li>
                                <hr class="dropdown-divider">
                                <li><a class="dropdown-item" href="<?= base_url('site/logout') ?>">Logout</a></li>
                            </ul>
                        </div>
                        <?php
                            }
                        ?>
                    </div>
                </div>
            </nav>
        </section>

        <div class="wave-content-navbar position-absolute">
            <img src="<?= base_url() . "assets/img/wave-nav.png" ?>" class="wave-img" alt="Wave">
        </div>

    </div>


    <script>
    const dropdownToggle = document.querySelector('.dropdown-toggle');
    const dropdownMenu = document.querySelector('.dropdown-menu');

    dropdownToggle.addEventListener('click', function(event) {
        //   event.preventDefault();
        dropdownMenu.classList.toggle('active');
    });


    document.addEventListener('click', function(event) {
        const targetElement = event.target;

        if (!targetElement.matches('.dropdown-toggle')) {
            dropdownMenu.classList.remove('active');
        }
    });
    </script>