<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
  }
  
  public function settings()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");
    
    
    $this->template->template_render('settings', $data);
  }
  
  public function meditations()
  {
    $data["meditations"] = $this->common->readdatafromcollectionbetween("Meditations");
    
    $this->template->template_render('meditations', $data);
  }

  public function addmeditation($id=null)
  {
    $data['meditation'] = null;
    $data['id'] = '';

    if($id){
      $data['meditation'] = $this->common->readdatadocument('Meditations', $id);
      $data['id'] = $id;
    }

    // var_dump($data['music']);die;

    $this->template->template_render('addmeditation', $data);
  }

  public function insertmeditation()
  {
    $post = $this->input->post();
    $data['sessionNo'] = $post['sessionNo'];
    $data['title'] = $post['title'];
    // $data['createdDate'] = time()*1000;
    // $data['isActive'] = true;

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();
    
    $image = '';
    if (
        isset($_FILES['image']) &&
        $_FILES['image']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['image']['tmp_name'])
    ) {
        $file_name = 'Meditations/Images/image-' . time() . basename($_FILES['image']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['image']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $image = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['image'] = $image;

    $audio1 = '';
    if (
        isset($_FILES['audio1']) &&
        $_FILES['audio1']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio1']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio1-' . time() . basename($_FILES['audio1']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio1']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio1 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audio1'] = $audio1;

    $audio2 = '';
    if (
        isset($_FILES['audio2']) &&
        $_FILES['audio2']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio2']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio2-' . time() . basename($_FILES['audio2']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio2']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio2 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audio2'] = $audio2;

    $audio3 = '';
    if (
        isset($_FILES['audio3']) &&
        $_FILES['audio3']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio3']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio3-' . time() . basename($_FILES['audio3']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio3']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio3 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audio3'] = $audio3;

    $response = $this->common->addnewdatamodel('Meditations', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Meditation added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/meditations'));
  }

  public function updatemeditation()
  {
    $post = $this->input->post();
    $id = $post['id'];
    $data['sessionNo'] = $post['sessionNo'];
    $data['title'] = $post['title'];

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    
    $image = '';
    if (
        isset($_FILES['image']) &&
        $_FILES['image']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['image']['tmp_name'])
    ) {
        $file_name = 'Meditations/Images/image-' . time() . basename($_FILES['image']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['image']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $image = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($image){

      $data['image'] = $image;
    }

    $audio1 = '';
    if (
        isset($_FILES['audio1']) &&
        $_FILES['audio1']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio1']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio1-' . time() . basename($_FILES['audio1']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio1']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio1 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audio1){

      $data['audio1'] = $audio1;
    }

    $audio2 = '';
    if (
        isset($_FILES['audio2']) &&
        $_FILES['audio2']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio2']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio2-' . time() . basename($_FILES['audio2']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio2']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio2 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audio2){

      $data['audio2'] = $audio2;
    }

    $audio3 = '';
    if (
        isset($_FILES['audio3']) &&
        $_FILES['audio3']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['audio3']['tmp_name'])
    ) {
        $file_name = 'Meditations/Audios/audio3-' . time() . basename($_FILES['audio3']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['audio3']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audio3 = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audio3){

      $data['audio3'] = $audio3;
    }

    $response = $this->common->updatedatamodel("Meditations", $id, $data);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Meditation has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/meditations'));
  }

  public function deleteMeditation()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('Meditations', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Meditation deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/meditations'));
	}


  public function backmusic()
  {
    $data["musics"] = $this->common->readdatafromcollectionbetween("BackgroundMusic");
    
    $this->template->template_render('music', $data);
  }

  public function addmusic($id=null)
  {
    $data['music'] = null;
    $data['id'] = '';

    if($id){
      $data['music'] = $this->common->readdatadocument('BackgroundMusic', $id);
      $data['id'] = $id;
    }

    // var_dump($data['music']);die;

    $this->template->template_render('addmusic', $data);
  }

  public function insertmusic()
  {
    $post = $this->input->post();
    $data['title'] = $post['title'];
    // $data['createdDate'] = time()*1000;
    // $data['isActive'] = true;

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();
    
    $audioFile = '';
    if (
        isset($_FILES['music']) &&
        $_FILES['music']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['music']['tmp_name'])
    ) {
        $file_name = 'BackgroundMusic/' . time() . basename($_FILES['music']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['music']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audioFile = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    $data['audioFile'] = $audioFile;

    $response = $this->common->addnewdatamodel('BackgroundMusic', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Background music added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/backmusic'));
  }

  public function updatemusic()
  {
    $post = $this->input->post();
    $id = $post['id'];
    $data['title'] = $post['title'];

    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    $audioFile = '';
    if (
        isset($_FILES['music']) &&
        $_FILES['music']['error'] === UPLOAD_ERR_OK &&
        is_uploaded_file($_FILES['music']['tmp_name'])
    ) {
        $file_name = 'BackgroundMusic/' . time() . basename($_FILES['music']['name']);
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['music']['tmp_name']),
            [
                'name' => $file_name,
                'predefinedAcl' => 'publicRead'
            ]
        );
        if ($uploadedFile) {
            $audioFile = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
        } else {
            throw new Exception("File upload failed! Firebase did not return a valid response.");
        }
    }

    if($audioFile){

      $data['audioFile'] = $audioFile;
    }

    $response = $this->common->updatedatamodel("BackgroundMusic", $id, $data);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Background music has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/backmusic'));
  }

  public function deleteMusic()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('BackgroundMusic', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Background music deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/backmusic'));
	}
  
//nexteddeletedatamodel
  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Settings has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }



  public function index()
  {
    $data['users1'] = $this->common->readnumberofdocumentsincollectionbetween('Users');
    $data['users1'] = $data['users1']-1;
    $data['meditations'] = $this->common->readnumberofdocumentsincollection('Meditations');
    $data['backmusic'] = $this->common->readnumberofdocumentsincollection('BackgroundMusic');
   
    $users = $this->common->readdatafromcollectionwhereclause("Users");
    $data['users']=count($users);
    foreach ($users as $key => $user) {
        if ($user['email'] == 'admin@example.com') {
          continue;
        }
        $timestamps[$key]    = $user['memberSince'];
    }
    array_multisort($timestamps, SORT_ASC, $users);
    $labels = array();

    $labels[0] = date('F', strtotime(date('F')." - 3 months"));
    for($i =1; $i<=5; $i++) {
      $timestamp = strtotime($labels[$i-1].' + 1 month');
      $labels[$i] = date('F', $timestamp);
    }
    $labelStr = '';
    foreach($labels as $label) {
      $labelStr .= '"'.$label.'", ';
    }
    
    $data['labelStr'] = $labelStr;
    $dataStr = '';
    for($i =0; $i<count($labels); $i++) {
      $num = 0;
      foreach($timestamps as $timestamp) {
        if($labels[$i] == date('F', $timestamp/1000)) {
          $num += 0.2;
        }
      }
      $dataStr .= $num.',';
    }
    $data['dataStr'] = $dataStr;

    $videos = $this->common->readdatafromcollectionwhereclause("Videos");
    $data['videos2']=count($videos);
    foreach ($videos as $key => $video) {
       
        $timestamps[$key]    = $video['publishDate'];
    }
    array_multisort($timestamps, SORT_ASC, $videos);
    $labels = array();

    $labels[0] = date('F', strtotime(date('F')." - 3 months"));
    for($i =1; $i<=5; $i++) {
      $timestamp = strtotime($labels[$i-1].' + 1 month');
      $labels[$i] = date('F', $timestamp);
    }
    $labelStr = '';
    foreach($labels as $label) {
      $labelStr .= '"'.$label.'", ';
    }
    
    $data['labelStrVideo'] = $labelStr;
    $dataStr = '';
    for($i =0; $i<count($labels); $i++) {
      $num = 0;
      foreach($timestamps as $timestamp) {
        if($labels[$i] == date('F', $timestamp/1000)) {
          $num += 0.2;
        }
      }
      $dataStr .= $num.',';
    }
    $data['dataStrVideo'] = $dataStr;

   
    $this->template->template_render('dashboard', $data);
  }

  public function quotes()
	{

		$data['quotes'] = $this->common->readdatafromcollectionwhereclause('Quotes');
		$this->template->template_render('quotes', $data);
	}

  public function categories()
	{

		$data['categories'] = $this->common->readdatafromcollectionwhereclause('Categories');
		$this->template->template_render('categories', $data);
	}

  public function addQuote()
	{

		$this->template->template_render('addquote');
	}

  public function addcategory()
	{

		$this->template->template_render('addcategory');
	}

  public function insertquote()
	{
		
		$post = $this->input->post();
    $data['quote'] = $post['quote'];
    $data['createdDate'] = time()*1000;
    $data['isActive'] = true;
    $response = $this->common->addnewdatamodel('Quotes', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Quote added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/quotes'));		
	}

  public function editquote()
	{
		$id = $this->uri->segment(3);
    $data['id'] = $id;
		$data['quote'] = $this->common->readdatadocument('Quotes', $id);
    if(!$data['quote']){
      redirect(base_url('dashboard/quotes'));
    }
		$this->template->template_render('editquote', $data);
	}

  public function updatequote()
	{
    $post = $this->input->post();
    $data['quote'] = $post['quote'];

		$response = $this->common->updatedatamodel('Quotes', $post['id'], $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Quote updated successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/quotes'));
	}

  public function deletequote()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('Quotes', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Quote deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/quotes'));
	}

  public function deleteQuestion()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->nexteddeletedatamodel('Journal', $_SESSION['type'], 'Questions', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Question deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/questions'));
	}

  public function deleteComment()
	{
    $videoId = $this->uri->segment(3);
    $commentId = $this->uri->segment(4);

 		$response = $this->common->nexteddeletedatamodel('Videos', $videoId, 'Comments', $commentId);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Comment deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/comments/'.$videoId));
	}

  public function deleteVideo()
	{
    $videoId = $this->uri->segment(3);

 		$response = $this->common->deletedatamodel('Videos', $videoId);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Video deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/reelzz'));
	}

  public function deleteReply()
	{
    $videoId = $this->uri->segment(3);
    $commentId = $this->uri->segment(4);
    $replyId = $this->uri->segment(5);

 		$response = $this->common->nexteddeletedatamodel2('Videos', $videoId, 'Comments', $commentId, 'reply', $replyId);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Reply deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/comments/'.$videoId));
	}

  public function insertcategory()
	{
		
		$post = $this->input->post();
    $data['title'] = $post['title'];
    $response = $this->common->addnewdatamodel('Categories', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));		
	}
	public function editcategory()
	{
		$id = $this->uri->segment(3);
    $data['id'] = $id;
		$data['category'] = $this->common->readdatadocument('Categories', $id);
		$this->template->template_render('addcategory', $data);
	}

	public function updatecategory()
	{
    $post = $this->input->post();
    $data['title'] = $post['title'];

		$response = $this->common->updatedatamodel('Categories', $post['id'], $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category updated successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
	}

  public function deletecategory()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->nexteddeletedatamodel('Categories', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
	}

}